/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder.util;

import java.nio.charset.Charset;

public class Decoder {
    private static final Charset UTF8 = Charset.forName("UTF8");

    public static String path(CharSequence path) {
        return Decoder.decode(path, false);
    }

    public static String query(CharSequence query) {
        return Decoder.decode(query, true);
    }

    public static String decode(CharSequence path, boolean query) {
        StringBuilder decoded = new StringBuilder();
        int length = path.length();
        int pos = 0;
        while (pos < length) {
            if (query && path.charAt(pos) == '+') {
                decoded.append(' ');
                ++pos;
                continue;
            }
            if (path.charAt(pos) == '%') {
                byte[] bytes = new byte[length / 3];
                int i = 0;
                boolean invalid = false;
                while (pos < length && path.charAt(pos) == '%') {
                    if (pos + 2 < length) {
                        try {
                            String hex = path.subSequence(pos + 1, pos + 3).toString();
                            int b = Integer.parseInt(hex, 16);
                            bytes[i++] = (byte)b;
                        }
                        catch (NumberFormatException e) {
                            invalid = true;
                        }
                    }
                    pos += 3;
                }
                if (!invalid) {
                    decoded.append(new String(bytes, 0, i, UTF8));
                    continue;
                }
                decoded.append('\ufffd');
                continue;
            }
            decoded.append(path.charAt(pos));
            ++pos;
        }
        return decoded.toString();
    }
}

