/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.faces;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.servlet.DispatcherType;
import org.ocpsoft.rewrite.servlet.http.HttpRewriteLifecycleListener;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.servlet.spi.DispatcherTypeProvider;

public class FacesRewriteLifecycleListener
extends HttpRewriteLifecycleListener {
    private static final String ORIGINAL_URL = FacesRewriteLifecycleListener.class.getName() + "_originalRequestURL";
    private List<DispatcherTypeProvider> dispatcherTypeProviders = null;

    public void beforeInboundLifecycle(HttpServletRewrite event) {
        if (DispatcherType.REQUEST.equals((Object)this.getDispatcherType(event))) {
            ((HttpServletRequest)event.getRequest()).setAttribute(ORIGINAL_URL, (Object)event.getAddress().getPathAndQuery());
        }
    }

    private DispatcherType getDispatcherType(HttpServletRewrite event) {
        for (DispatcherTypeProvider provider : this.getDispatcherTypeProviders()) {
            DispatcherType dispatcherType = provider.getDispatcherType(event.getRequest(), event.getServletContext());
            if (dispatcherType == null) continue;
            return dispatcherType;
        }
        throw new IllegalStateException("Unable to determine dispatcher type of current request");
    }

    private List<DispatcherTypeProvider> getDispatcherTypeProviders() {
        if (this.dispatcherTypeProviders == null) {
            this.dispatcherTypeProviders = Iterators.asList((Iterator)ServiceLoader.loadTypesafe(DispatcherTypeProvider.class).iterator());
            Collections.sort(this.dispatcherTypeProviders, new WeightedComparator());
        }
        return this.dispatcherTypeProviders;
    }

    public static String getOriginalRequestURL(HttpServletRequest request) {
        return (String)request.getAttribute(ORIGINAL_URL);
    }

    public void beforeInboundRewrite(HttpServletRewrite event) {
    }

    public void afterInboundRewrite(HttpServletRewrite event) {
    }

    public void beforeOutboundRewrite(HttpServletRewrite event) {
    }

    public void afterOutboundRewrite(HttpServletRewrite event) {
    }

    public void afterInboundLifecycle(HttpServletRewrite event) {
    }

    public int priority() {
        return 0;
    }
}

