/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.param;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.Constraint;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.param.Transposition;
import org.ocpsoft.rewrite.spi.GlobalParameterProvider;
import org.ocpsoft.rewrite.util.ServiceLogger;

public class DefaultParameterValueStore
implements ParameterValueStore,
Iterable<Map.Entry<Parameter<?>, String>> {
    Map<Parameter<?>, String> map = new LinkedHashMap();
    private static List<GlobalParameterProvider> providers;
    private static final Logger log;

    public DefaultParameterValueStore() {
        if (providers == null) {
            providers = Iterators.asList((Iterable)ServiceLoader.load(GlobalParameterProvider.class));
            ServiceLogger.logLoadedServices(log, GlobalParameterProvider.class, providers);
        }
    }

    public DefaultParameterValueStore(DefaultParameterValueStore instance) {
        for (Map.Entry<Parameter<?>, String> entry : instance) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String retrieve(Parameter<?> parameter) {
        String value = this.map.get(parameter);
        return value;
    }

    @Override
    public boolean submit(Rewrite event, EvaluationContext context, Parameter<?> param, String value) {
        Assert.notNull((Object)event, (String)"Rewrite event must not be null.");
        Assert.notNull((Object)context, (String)"EvaluationContext must not be null.");
        Assert.notNull(param, (String)"Parameter must not be null.");
        boolean result = false;
        boolean supportsSubmission = this.supportsSubmission(event, context, param, value);
        if (!supportsSubmission) {
            result = true;
        } else if (supportsSubmission && this.isValid(event, context, param, value)) {
            for (Transposition<String> transposition : param.getTranspositions()) {
                value = transposition.transpose(event, context, value);
            }
            this.map.put(param, value);
            result = true;
        }
        return result;
    }

    private boolean supportsSubmission(Rewrite event, EvaluationContext context, Parameter<?> param, String value) {
        boolean result = true;
        block0: for (GlobalParameterProvider provider : providers) {
            Set<Parameter<?>> params = provider.getParameters();
            if (params == null) continue;
            for (Parameter<?> parameter : params) {
                if (parameter == null || parameter.getName() == null || !parameter.getName().equals(param.getName())) continue;
                result = provider.supportsSubmission(event, context, parameter);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public boolean isValid(Rewrite event, EvaluationContext context, Parameter<?> param, String value) {
        Assert.notNull((Object)event, (String)"Rewrite event must not be null.");
        Assert.notNull((Object)context, (String)"EvaluationContext must not be null.");
        Assert.notNull(param, (String)"Parameter must not be null.");
        String stored = this.map.get(param);
        boolean result = false;
        if (this._doParameterProviderValidation(event, context, param, value)) {
            result = true;
        } else if (stored == value || stored != null && stored.equals(value)) {
            result = true;
        } else if (stored == null) {
            result = true;
            for (Constraint<String> constraint : param.getConstraints()) {
                if (constraint.isSatisfiedBy(event, context, value)) continue;
                result = false;
            }
        }
        return result;
    }

    private boolean _doParameterProviderValidation(Rewrite event, EvaluationContext context, Parameter<?> param, String value) {
        boolean result = false;
        block0: for (GlobalParameterProvider provider : providers) {
            Set<Parameter<?>> params = provider.getParameters();
            if (params == null) continue;
            for (Parameter<?> parameter : params) {
                if (parameter == null || parameter.getName() == null || !parameter.getName().equals(param.getName())) continue;
                result = provider.isValid(event, context, param, value);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Parameter<?>, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    public static ParameterValueStore getInstance(EvaluationContext context) throws IllegalStateException {
        ParameterValueStore valueStore = (ParameterValueStore)context.get(ParameterValueStore.class);
        if (valueStore == null) {
            throw new IllegalStateException("Could not retrieve " + ParameterValueStore.class.getName() + " from " + EvaluationContext.class.getName() + ". Has the " + EvaluationContext.class.getSimpleName() + " been set up properly?");
        }
        return valueStore;
    }

    static {
        log = Logger.getLogger(DefaultParameterValueStore.class);
    }
}

