/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.parameter.Encoding;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.EncoderFactory;
import org.ocpsoft.prettytime.shade.org.apache.commons.codec.BinaryEncoder;
import org.ocpsoft.prettytime.shade.org.apache.commons.codec.StringEncoder;
import org.ocpsoft.prettytime.shade.org.apache.commons.codec.binary.Base64;
import org.ocpsoft.prettytime.shade.org.apache.commons.codec.net.QuotedPrintableCodec;

public class DefaultEncoderFactory
extends EncoderFactory {
    private static final String UNSUPPORTED_ENCODING_MESSAGE = "Encoder not available for encoding [{0}]";

    public BinaryEncoder createBinaryEncoder(Encoding encoding) throws UnsupportedEncodingException {
        if (Encoding.QUOTED_PRINTABLE.equals(encoding)) {
            return new QuotedPrintableCodec();
        }
        if (Encoding.BASE64.equals(encoding)) {
            return new Base64();
        }
        throw new UnsupportedEncodingException(MessageFormat.format(UNSUPPORTED_ENCODING_MESSAGE, encoding));
    }

    public StringEncoder createStringEncoder(Encoding encoding) throws UnsupportedEncodingException {
        if (Encoding.QUOTED_PRINTABLE.equals(encoding)) {
            return new QuotedPrintableCodec();
        }
        throw new UnsupportedEncodingException(MessageFormat.format(UNSUPPORTED_ENCODING_MESSAGE, encoding));
    }
}

