/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property;

import java.math.BigDecimal;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ParameterList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Property;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PropertyFactoryImpl;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.shade.org.apache.commons.lang.StringUtils;

public class Geo
extends Property {
    private static final long serialVersionUID = -902100715801867636L;
    private BigDecimal latitude;
    private BigDecimal longitude;

    public Geo() {
        super("GEO", PropertyFactoryImpl.getInstance());
        this.latitude = BigDecimal.valueOf(0L);
        this.longitude = BigDecimal.valueOf(0L);
    }

    public Geo(String value) {
        super("GEO", PropertyFactoryImpl.getInstance());
        this.setValue(value);
    }

    public Geo(ParameterList aList, String aValue) {
        super("GEO", aList, PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public Geo(BigDecimal latitude, BigDecimal longitude) {
        super("GEO", PropertyFactoryImpl.getInstance());
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Geo(ParameterList aList, BigDecimal latitude, BigDecimal longitude) {
        super("GEO", aList, PropertyFactoryImpl.getInstance());
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public final BigDecimal getLatitude() {
        return this.latitude;
    }

    public final BigDecimal getLongitude() {
        return this.longitude;
    }

    public final void setValue(String aValue) {
        String latitudeString = aValue.substring(0, aValue.indexOf(59));
        this.latitude = StringUtils.isNotBlank(latitudeString) ? new BigDecimal(latitudeString) : BigDecimal.valueOf(0L);
        String longitudeString = aValue.substring(aValue.indexOf(59) + 1);
        this.longitude = StringUtils.isNotBlank(longitudeString) ? new BigDecimal(longitudeString) : BigDecimal.valueOf(0L);
    }

    public final String getValue() {
        return String.valueOf(this.getLatitude()) + ";" + String.valueOf(this.getLongitude());
    }

    public final void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public final void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public final void validate() throws ValidationException {
    }
}

