/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.Available;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.CalendarComponent;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.Daylight;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.Standard;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VAlarm;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VAvailability;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VEvent;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VFreeBusy;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VJournal;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VTimeZone;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VToDo;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.VVenue;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.XComponent;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.CompatibilityHints;

public final class ComponentFactory {
    private static ComponentFactory instance = new ComponentFactory();

    private ComponentFactory() {
    }

    public static ComponentFactory getInstance() {
        return instance;
    }

    public Component createComponent(String name) {
        return this.createComponent(name, new PropertyList());
    }

    public Component createComponent(String name, PropertyList properties) {
        Component component = null;
        if ("VALARM".equals(name)) {
            component = new VAlarm(properties);
        } else if ("VEVENT".equals(name)) {
            component = new VEvent(properties);
        } else if ("VFREEBUSY".equals(name)) {
            component = new VFreeBusy(properties);
        } else if ("VJOURNAL".equals(name)) {
            component = new VJournal(properties);
        } else if ("VTODO".equals(name)) {
            component = new VToDo(properties);
        } else if ("STANDARD".equals(name)) {
            component = new Standard(properties);
        } else if ("DAYLIGHT".equals(name)) {
            component = new Daylight(properties);
        } else if ("VTIMEZONE".equals(name)) {
            component = new VTimeZone(properties);
        } else if ("VVENUE".equals(name)) {
            component = new VVenue(properties);
        } else if ("VAVAILABILITY".equals(name)) {
            component = new VAvailability(properties);
        } else if ("AVAILABLE".equals(name)) {
            component = new Available(properties);
        } else if (this.isExperimentalName(name)) {
            component = new XComponent(name, properties);
        } else if (this.allowIllegalNames()) {
            component = new XComponent(name, properties);
        } else {
            throw new IllegalArgumentException("Illegal component [" + name + "]");
        }
        return component;
    }

    public Component createComponent(String name, PropertyList properties, ComponentList components) {
        if (components != null) {
            CalendarComponent component = null;
            if ("VTIMEZONE".equals(name)) {
                component = new VTimeZone(properties, components);
            } else if ("VEVENT".equals(name)) {
                component = new VEvent(properties, components);
            } else {
                throw new IllegalArgumentException("Illegal component [" + name + "]");
            }
            return component;
        }
        return this.createComponent(name, properties);
    }

    private boolean isExperimentalName(String name) {
        return name.startsWith("X-") && name.length() > "X-".length();
    }

    protected boolean allowIllegalNames() {
        return CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed");
    }
}

