/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.Executors;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.Future;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import org.ocpsoft.prettytime.shade.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;

public class Executors {
    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory));
    }

    public static ExecutorService newCachedThreadPool() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new DelegatedScheduledExecutorService(new ScheduledThreadPoolExecutor(1, threadFactory));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return new ScheduledThreadPoolExecutor(corePoolSize);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return new DelegatedExecutorService(executor);
    }

    public static ScheduledExecutorService unconfigurableScheduledExecutorService(ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return new DelegatedScheduledExecutorService(executor);
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        return new PrivilegedThreadFactory();
    }

    public static Callable callable(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(task, result);
    }

    public static Callable callable(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(task, null);
    }

    public static Callable callable(final PrivilegedAction action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return new Callable(){

            public Object call() {
                return action.run();
            }
        };
    }

    public static Callable callable(final PrivilegedExceptionAction action) {
        if (action == null) {
            throw new NullPointerException();
        }
        return new Callable(){

            public Object call() throws Exception {
                return action.run();
            }
        };
    }

    public static Callable privilegedCallable(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallable(callable);
    }

    public static Callable privilegedCallableUsingCurrentClassLoader(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallableUsingCurrentClassLoader(callable);
    }

    private Executors() {
    }

    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
            this.e = executor;
        }

        public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
            return this.e.schedule(command, delay, unit);
        }

        public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
            return this.e.schedule(callable, delay, unit);
        }

        public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.e.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.e.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executor) {
            super(executor);
        }

        protected void finalize() {
            super.shutdown();
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executor) {
            this.e = executor;
        }

        public void execute(Runnable command) {
            this.e.execute(command);
        }

        public void shutdown() {
            this.e.shutdown();
        }

        public List shutdownNow() {
            return this.e.shutdownNow();
        }

        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        public Future submit(Runnable task) {
            return this.e.submit(task);
        }

        public Future submit(Callable task) {
            return this.e.submit(task);
        }

        public Future submit(Runnable task, Object result) {
            return this.e.submit(task, result);
        }

        public List invokeAll(Collection tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(tasks);
        }

        public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(tasks, timeout, unit);
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        private final AccessControlContext acc = AccessController.getContext();

        PrivilegedThreadFactory() {
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Thread newThread(Runnable r) {
            return super.newThread(new Runnable(this, r){
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ PrivilegedThreadFactory this$0;
                {
                    this.this$0 = this$0;
                    this.val$r = val$r;
                }

                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(PrivilegedThreadFactory.access$800(5.access$700(this.this$1)));
                            5.access$900(this.this$1).run();
                            return null;
                        }
                    }, PrivilegedThreadFactory.access$1000(this.this$0));
                }

                static /* synthetic */ PrivilegedThreadFactory access$700(5 x0) {
                    return x0.this$0;
                }

                static /* synthetic */ Runnable access$900(5 x0) {
                    return x0.val$r;
                }
            });
        }

        static /* synthetic */ ClassLoader access$800(PrivilegedThreadFactory x0) {
            return x0.ccl;
        }

        static /* synthetic */ AccessControlContext access$1000(PrivilegedThreadFactory x0) {
            return x0.acc;
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static final class PrivilegedCallableUsingCurrentClassLoader
    implements Callable {
        private final ClassLoader ccl;
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        PrivilegedCallableUsingCurrentClassLoader(Callable task) {
            this.task = task;
            this.ccl = Thread.currentThread().getContextClassLoader();
            this.acc = AccessController.getContext();
            this.acc.checkPermission(new RuntimePermission("getContextClassLoader"));
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ PrivilegedCallableUsingCurrentClassLoader this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ClassLoader savedcl = null;
                    Thread t = Thread.currentThread();
                    try {
                        ClassLoader cl = t.getContextClassLoader();
                        if (PrivilegedCallableUsingCurrentClassLoader.access$300(this.this$0) != cl) {
                            t.setContextClassLoader(PrivilegedCallableUsingCurrentClassLoader.access$300(this.this$0));
                            savedcl = cl;
                        }
                        PrivilegedCallableUsingCurrentClassLoader.access$402(this.this$0, PrivilegedCallableUsingCurrentClassLoader.access$500(this.this$0).call());
                        if (savedcl != null) {
                            t.setContextClassLoader(savedcl);
                        }
                    }
                    catch (Exception ex) {
                        PrivilegedCallableUsingCurrentClassLoader.access$602(this.this$0, ex);
                    }
                    finally {
                        if (savedcl != null) {
                            t.setContextClassLoader(savedcl);
                        }
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static /* synthetic */ ClassLoader access$300(PrivilegedCallableUsingCurrentClassLoader x0) {
            return x0.ccl;
        }

        static /* synthetic */ Object access$402(PrivilegedCallableUsingCurrentClassLoader x0, Object x1) {
            x0.result = x1;
            return x0.result;
        }

        static /* synthetic */ Callable access$500(PrivilegedCallableUsingCurrentClassLoader x0) {
            return x0.task;
        }

        static /* synthetic */ Exception access$602(PrivilegedCallableUsingCurrentClassLoader x0, Exception x1) {
            x0.exception = x1;
            return x0.exception;
        }
    }

    static final class PrivilegedCallable
    implements Callable {
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        PrivilegedCallable(Callable task) {
            this.task = task;
            this.acc = AccessController.getContext();
        }

        public Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ PrivilegedCallable this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() {
                    try {
                        PrivilegedCallable.access$002(this.this$0, PrivilegedCallable.access$100(this.this$0).call());
                    }
                    catch (Exception ex) {
                        PrivilegedCallable.access$202(this.this$0, ex);
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        static /* synthetic */ Object access$002(PrivilegedCallable x0, Object x1) {
            x0.result = x1;
            return x0.result;
        }

        static /* synthetic */ Callable access$100(PrivilegedCallable x0) {
            return x0.task;
        }

        static /* synthetic */ Exception access$202(PrivilegedCallable x0, Exception x1) {
            x0.exception = x1;
            return x0.exception;
        }
    }

    static final class RunnableAdapter
    implements Callable {
        final Runnable task;
        final Object result;

        RunnableAdapter(Runnable task, Object result) {
            this.task = task;
            this.result = result;
        }

        public Object call() {
            this.task.run();
            return this.result;
        }
    }
}

