/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck.search;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.SortedSet;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.PlatformDescription;
import org.objenesis.tck.candidates.SerializableNoConstructor;
import org.objenesis.tck.search.ClassEnumerator;
import org.objenesis.tck.search.SearchWorkingInstantiatorListener;
import org.objenesis.tck.search.SystemOutListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchWorkingInstantiator
implements Serializable {
    private SearchWorkingInstantiatorListener listener;

    public static void main(String[] args) throws Exception {
        System.out.println();
        System.out.println(PlatformDescription.describePlatform());
        System.out.println();
        SearchWorkingInstantiator searchWorkingInstantiator = new SearchWorkingInstantiator(new SystemOutListener());
        searchWorkingInstantiator.searchForInstantiator(SerializableNoConstructor.class);
    }

    public SearchWorkingInstantiator(SearchWorkingInstantiatorListener listener) {
        this.listener = listener;
    }

    public void searchForInstantiator(Class<?> toInstantiate) {
        SortedSet<Class<?>> classes = ClassEnumerator.getClassesForPackage(ObjectInstantiator.class.getPackage());
        for (Class clazz : classes) {
            Constructor constructor;
            if (clazz.isInterface() || !ObjectInstantiator.class.isAssignableFrom(clazz)) continue;
            try {
                constructor = clazz.getConstructor(Class.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                ObjectInstantiator instantiator = (ObjectInstantiator)constructor.newInstance(toInstantiate);
                instantiator.newInstance();
                this.listener.instantiatorSupported(clazz);
            }
            catch (Exception e) {
                Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
                this.listener.instantiatorUnsupported(clazz, t);
            }
        }
    }
}

