/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ChainManager;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.core.util.PathMatcher;
import org.noear.solon.core.util.PathUtil;

public class RouterDefault
implements Router,
HandlerSlots {
    private final ChainManager chains;
    private final RoutingTable<Handler> table = new RoutingTableDefault<Handler>();
    private List<Map.Entry<String, Predicate<Class<?>>>> pathPrefixTester = new ArrayList();

    public RouterDefault(ChainManager chains) {
        this.chains = chains;
    }

    @Override
    public void caseSensitive(boolean caseSensitive) {
        PathMatcher.setCaseSensitive(caseSensitive);
    }

    @Override
    public void addPathPrefix(String pathPrefix, Predicate<Class<?>> tester) {
        this.pathPrefixTester.add(new AbstractMap.SimpleEntry(pathPrefix, tester));
    }

    private void doAdd(String path, MethodType method, int index, Handler handler) {
        RoutingDefault<Handler> routing = new RoutingDefault<Handler>(path, handler.version(), method, index, handler);
        this.table.add(routing);
    }

    private String doGetPathPrefix(Class<?> clz) {
        for (Map.Entry<String, Predicate<Class<?>>> entry : this.pathPrefixTester) {
            if (!entry.getValue().test(clz)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void add(String path, MethodType method, int index, Handler handler) {
        String pp0;
        if (this.pathPrefixTester.size() > 0 && (pp0 = handler instanceof Action ? this.doGetPathPrefix(((Action)handler).controller().rawClz()) : this.doGetPathPrefix(handler.getClass())) != null) {
            path = PathUtil.mergePath(pp0, path);
        }
        this.doAdd(path, method, index, handler);
    }

    @Override
    public void add(String pathPrefix, BeanWrap bw, boolean remoting) {
        if (bw != null) {
            String pp0;
            if (this.pathPrefixTester.size() > 0 && (pp0 = this.doGetPathPrefix(bw.rawClz())) != null) {
                pathPrefix = pathPrefix == null ? pp0 : PathUtil.mergePath(pp0, pathPrefix);
            }
            FactoryManager.getGlobal().createLoader(bw, remoting).withPathPrefix(pathPrefix).load(this::doAdd);
        }
    }

    @Override
    public Result<Handler> matchMainAndStatus(Context ctx) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodTypeUtil.valueOf(ctx.method());
        return this.table.matchOneAndStatus(pathNew, ctx.getVersion(), method);
    }

    @Override
    public Handler matchMain(Context ctx) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodTypeUtil.valueOf(ctx.method());
        return this.table.matchOne(pathNew, ctx.getVersion(), method);
    }

    @Override
    public Collection<Routing<Handler>> findAll() {
        return this.table.getAll();
    }

    @Override
    public Collection<Routing<Handler>> findBy(String pathPrefix) {
        return this.table.getBy(pathPrefix);
    }

    @Override
    public Collection<Routing<Handler>> findBy(Class<?> controllerClz) {
        return this.table.getBy(controllerClz);
    }

    @Override
    public void remove(String pathPrefix) {
        this.table.remove(pathPrefix);
    }

    @Override
    public void remove(Class<?> controllerClz) {
        this.table.remove(controllerClz);
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public void filter(int index, Filter filter) {
        this.chains.addFilter(filter, index);
    }

    @Override
    public void filterIfAbsent(int index, Filter filter) {
        this.chains.addFilterIfAbsent(filter, index);
    }

    @Override
    public void routerInterceptor(int index, RouterInterceptor interceptor) {
        this.chains.addRouterInterceptor(interceptor, index);
    }

    @Override
    public void routerInterceptorIfAbsent(int index, RouterInterceptor interceptor) {
        this.chains.addRouterInterceptorIfAbsent(interceptor, index);
    }

    @Override
    public void add(String expr, MethodType method, Handler handler) {
        this.add(expr, method, 0, handler);
    }
}

