/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.lang.Nullable;

public final class Assert {
    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(Collection s) {
        return s == null || s.size() == 0;
    }

    public static boolean isEmpty(Map s) {
        return s == null || s.size() == 0;
    }

    public static boolean isEmpty(MultiMap s) {
        return s == null || s.size() == 0;
    }

    public static <T> boolean isEmpty(T[] s) {
        return s == null || s.length == 0;
    }

    public static <T> boolean isEmpty(Properties s) {
        return s == null || s.size() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !Assert.isEmpty(s);
    }

    public static boolean isNotEmpty(Collection s) {
        return !Assert.isEmpty(s);
    }

    public static <T> boolean isNotEmpty(T[] s) {
        return !Assert.isEmpty(s);
    }

    public static boolean isNotEmpty(Map s) {
        return !Assert.isEmpty(s);
    }

    public static boolean isNotEmpty(Properties s) {
        return !Assert.isEmpty(s);
    }

    public static boolean isBlank(String s) {
        if (Assert.isEmpty(s)) {
            return true;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (Assert.isWhitespace(s.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String s) {
        return !Assert.isBlank(s);
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static void notEmpty(@Nullable Collection<?> collection, String message) {
        if (Assert.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, String message) {
        if (Assert.isEmpty(map)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(@Nullable String text, String message) {
        if (Assert.isEmpty(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notBlank(@Nullable String text, String message) {
        if (Assert.isBlank(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(@Nullable Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }
}

