/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.Method;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.lang.Nullable;

public class MethodKey
implements Comparable<MethodKey> {
    private final Method method;
    @Nullable
    private final Class<?> targetClass;

    public MethodKey(Method method, @Nullable Class<?> targetClass) {
        this.method = method;
        this.targetClass = targetClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodKey)) {
            return false;
        }
        MethodKey other = (MethodKey)o;
        return this.targetClass == other.targetClass && this.method.getName().equals(other.method.getName()) && this.method.getReturnType().equals(other.method.getReturnType()) && ClassUtil.equalParamTypes(this.method.getParameterTypes(), other.method.getParameterTypes());
    }

    public int hashCode() {
        if (this.targetClass == null) {
            return this.method.hashCode();
        }
        return this.targetClass.getName().hashCode() ^ this.method.getName().hashCode();
    }

    public String toString() {
        if (this.targetClass == null) {
            return this.method.toString();
        }
        return this.method.toString() + " on " + this.targetClass.getName();
    }

    @Override
    public int compareTo(MethodKey o) {
        int result = this.method.getName().compareTo(o.method.getName());
        if (result == 0 && (result = this.method.toString().compareTo(o.method.toString())) == 0 && this.targetClass != null && o.targetClass != null) {
            result = this.targetClass.getName().compareTo(o.targetClass.getName());
        }
        return result;
    }
}

