/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.core.runtime.RuntimeService;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.lang.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClassIndexUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassIndexUtil.class);
    private static final String INDEX_FILE_SUFFIX = ".index";
    private static final String INDEX_FILE_DIR = "META-INF/solon-index/";

    public static List<String> loadClassIndex(String basePackage) {
        String indexFileName = ClassIndexUtil.getIndexFileName(basePackage);
        try {
            URL resourceUrl = ResourceUtil.getResource(INDEX_FILE_DIR + indexFileName);
            if (resourceUrl == null) {
                return null;
            }
            ArrayList<String> classNames = new ArrayList<String>();
            try (InputStream inputStream = resourceUrl.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    classNames.add(line.trim());
                }
            }
            return classNames;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getIndexFileName(String basePackage) {
        if (basePackage == null || basePackage.isEmpty()) {
            throw new IllegalArgumentException("basePackage cannot be null or empty");
        }
        if (basePackage.contains("..") || basePackage.contains("/") || basePackage.contains("\\")) {
            throw new IllegalArgumentException("Invalid basePackage: contains path traversal characters");
        }
        return basePackage.replace('.', '-') + INDEX_FILE_SUFFIX;
    }

    public static boolean writeIndexFile(String basePackage, List<String> classNames) {
        String indexFileName = ClassIndexUtil.getIndexFileName(basePackage);
        File indexFile = RuntimeService.global().createClassOutputFile(INDEX_FILE_DIR + indexFileName);
        try {
            indexFile.getParentFile().mkdirs();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), StandardCharsets.UTF_8));){
                for (String className : classNames) {
                    writer.write(className);
                    writer.newLine();
                }
            }
            return true;
        }
        catch (IOException e) {
            log.warn("Failed to write class index file for package: {}", (Object)basePackage, (Object)e);
            return false;
        }
    }
}

