/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.noear.solon.SolonApp;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.lang.Preview;
import org.noear.solon.logging.LogIncubator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Solon {
    private static SolonApp app;
    private static SolonApp appMain;
    private static String encoding;
    private static URL location;
    static Logger log;

    public static String version() {
        return "3.7.0-M1";
    }

    public static SolonApp app() {
        return app;
    }

    public static boolean appIf(Function<SolonApp, Boolean> condition) {
        return app != null && condition.apply(app) != false;
    }

    protected static void appSet(SolonApp solonApp) {
        if (solonApp != null) {
            app = solonApp;
        }
    }

    public static SolonProps cfg() {
        if (app == null) {
            return null;
        }
        return app.cfg();
    }

    public static AppContext context() {
        if (app == null) {
            return null;
        }
        return app.context();
    }

    public static URL location() {
        return location;
    }

    public static String encoding() {
        return encoding;
    }

    public static void encodingSet(String charset) {
        if (app == null && Utils.isNotEmpty(charset)) {
            encoding = charset;
        }
    }

    public static SolonApp start(Class<?> source, String[] args) {
        return Solon.start(source, args, null);
    }

    public static SolonApp start(Class<?> source, ConsumerEx<SolonApp> initialize) {
        return Solon.start(source, new String[0], initialize);
    }

    public static SolonApp start(Class<?> source, String[] args, ConsumerEx<SolonApp> initialize) {
        MultiMap<String> argx = MultiMap.from(args);
        return Solon.start(source, argx, initialize);
    }

    @Deprecated
    public static SolonApp start(Class<?> source, NvMap args, ConsumerEx<SolonApp> initialize) {
        MultiMap argx = new MultiMap().then(e -> e.putAll(args));
        return Solon.start(source, argx, initialize);
    }

    public static SolonApp start(Class<?> source, MultiMap<String> argx, ConsumerEx<SolonApp> initialize) {
        if (appMain != null) {
            app = appMain;
            return appMain;
        }
        if (Utils.isNotEmpty(encoding)) {
            System.setProperty("file.encoding", encoding);
        }
        System.getProperties().putIfAbsent("java.awt.headless", "true");
        location = source.getProtectionDomain().getCodeSource().getLocation();
        String pid = Utils.pid();
        AppClassLoader.bindingThread();
        try {
            app = appMain = new SolonApp(source, argx);
            Solon.logIncubate();
            log.info("App: Start loading");
            app.startDo(initialize);
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            log.error("Solon start failed: " + e.getMessage(), e);
            if (NativeDetector.isNotAotRuntime()) {
                Solon.stop0(true, 0);
            }
            Solon.stop0(false, 0);
            throw new IllegalStateException("Solon start failed", e);
        }
        if (NativeDetector.isNotAotRuntime()) {
            if (app.cfg().stopSafe()) {
                int stopDelay = app.cfg().stopDelay();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, stopDelay)));
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, 0)));
            }
        }
        log.info("App: End loading elapsed=" + app.elapsedTimes() + "ms pid=" + pid + " v=" + Solon.version());
        return app;
    }

    private static void logIncubate() throws Throwable {
        ServiceLoader<LogIncubator> internetServices = ServiceLoader.load(LogIncubator.class);
        for (LogIncubator logIncubator : internetServices) {
            logIncubator.incubate();
        }
    }

    public static void stop() {
        if (app.cfg().stopSafe()) {
            Solon.stop(app.cfg().stopDelay());
        } else {
            Solon.stop(0);
        }
    }

    public static void stop(int delay) {
        new Thread(() -> Solon.stop0(true, delay)).start();
    }

    @Preview(value="3.0")
    public static void stopBlock() {
        Solon.stop0(false, 0);
    }

    public static void stopBlock(boolean exit, int delay) {
        Solon.stop0(exit, delay);
    }

    public static void stopBlock(boolean exit, int delay, int exitStatus) {
        Solon.stop0(exit, delay, exitStatus);
    }

    private static void stop0(boolean exit, int delay) {
        Solon.stop0(exit, delay, 1);
    }

    private static void stop0(boolean exit, int delay, int exitStatus) {
        if (Solon.app() == null) {
            return;
        }
        if (delay > 0) {
            log.info("App: Security to stop: begin...(1.prestop 2.delay 3.stop)");
            Solon.app().prestopDo();
            log.info("App: Security to stop: 1/3 completed");
            log.info("App: Security to stop: delay " + delay + "s...");
            int delay1 = (int)((double)delay * 0.3);
            int delay2 = delay - delay1;
            if (delay1 > 0) {
                Solon.sleep0(delay1);
            }
            Solon.app().stoppingDo();
            if (delay2 > 0) {
                Solon.sleep0(delay2);
            }
            log.info("App: Security to stop: 2/3 completed");
            Solon.app().stopDo();
            log.info("App: Security to stop: 3/3 completed");
        } else {
            Solon.app().prestopDo();
            Solon.app().stoppingDo();
            Solon.app().stopDo();
        }
        log.info("App: Stopped");
        app = null;
        appMain = null;
        if (exit) {
            System.exit(exitStatus);
        }
    }

    private static void sleep0(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        encoding = "UTF-8";
        log = LoggerFactory.getLogger(Solon.class);
    }
}

