/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.AnnotatedElement;
import java.util.function.BiFunction;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.MvcFactory;
import org.noear.solon.core.handle.ActionLoader;
import org.noear.solon.core.handle.ActionLoaderFactory;
import org.noear.solon.core.handle.ActionParam;
import org.noear.solon.core.handle.EntityConverter;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ClassUtil;

public final class FactoryManager {
    private static final FactoryManager global = new FactoryManager();
    private BiFunction<Class<?>, Boolean, ThreadLocal> threadLocalFactory = (applyFor, inheritance0) -> {
        if (inheritance0.booleanValue()) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    };
    private LoadBalance.Factory loadBalanceFactory = (g, s) -> null;
    private ActionLoaderFactory actionLoaderFactory = (ActionLoaderFactory)ClassUtil.tryInstance("org.noear.solon.extend.impl.ActionLoaderFactoryExt");

    public static FactoryManager getGlobal() {
        return global;
    }

    public <T> void threadLocalFactory(BiFunction<Class<?>, Boolean, ThreadLocal> factory) {
        if (factory != null) {
            this.threadLocalFactory = factory;
        }
    }

    public <T> ThreadLocal<T> newThreadLocal(Class<?> applyFor, boolean inheritance0) {
        return this.threadLocalFactory.apply(applyFor, inheritance0);
    }

    public void loadBalanceFactory(LoadBalance.Factory factory) {
        if (factory != null) {
            this.loadBalanceFactory = factory;
        }
    }

    public LoadBalance newLoadBalance(String group, String service) {
        return this.loadBalanceFactory.create(group, service);
    }

    @Deprecated
    public boolean hasMvcFactory() {
        throw new UnsupportedOperationException();
    }

    public MvcFactory mvcFactory() {
        throw new UnsupportedOperationException();
    }

    public void mvcFactory(MvcFactory factory) {
        throw new UnsupportedOperationException();
    }

    public ActionLoaderFactory actionLoaderFactory() {
        if (this.actionLoaderFactory == null) {
            throw new IllegalStateException("The 'solon-handle' plugin is missing");
        }
        return this.actionLoaderFactory;
    }

    public void actionLoaderFactory(ActionLoaderFactory factory) {
        if (factory != null) {
            this.actionLoaderFactory = factory;
        }
    }

    public ActionLoader createLoader(BeanWrap wrap) {
        return this.actionLoaderFactory().createLoader(wrap);
    }

    public ActionLoader createLoader(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        return this.actionLoaderFactory().createLoader(wrap, mapping, remoting, render, allowMapping);
    }

    public void resolveActionParamTry(ActionParam vo, AnnotatedElement element) {
        if (this.actionLoaderFactory != null) {
            this.actionLoaderFactory.resolveActionParam(vo, element);
        }
    }

    public EntityConverter entityConverterDefault() {
        return this.actionLoaderFactory().getEntityConverterDefault();
    }
}

