/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;

public class ContextPathFilter
implements Filter {
    private final String contextPath0;
    private final String contextPath1;
    private final boolean forced;

    public ContextPathFilter() {
        this(Solon.cfg().serverContextPath(), Solon.cfg().serverContextPathForced());
    }

    public ContextPathFilter(String contextPath, boolean forced) {
        this.forced = forced;
        if (Utils.isEmpty(contextPath)) {
            this.contextPath0 = null;
            this.contextPath1 = null;
        } else {
            String newPath = null;
            newPath = contextPath.endsWith("/") ? contextPath : contextPath + "/";
            this.contextPath1 = newPath.startsWith("/") ? newPath : "/" + newPath;
            this.contextPath0 = this.contextPath1.substring(0, this.contextPath1.length() - 1);
            Solon.cfg().serverContextPath(this.contextPath1);
        }
    }

    @Override
    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        if (this.contextPath0 != null) {
            if (ctx.pathNew().equals(this.contextPath0)) {
                ctx.pathNew("/");
            } else if (ctx.pathNew().startsWith(this.contextPath1)) {
                ctx.pathNew(ctx.pathNew().substring(this.contextPath1.length() - 1));
            } else if (this.forced) {
                ctx.status(404);
                return;
            }
        }
        chain.doFilter(ctx);
    }
}

