/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrapLifecycle;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.GenericUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWrap {
    static final Logger log = LoggerFactory.getLogger(BeanWrap.class);
    private Class<?> clz;
    private BeanWrapLifecycle lifecycle;
    private Constructor rawCtor;
    private Object[] rawCtorArgs;
    private Object raw;
    private Object rawUnproxied;
    private Class<?> rawClz;
    private boolean singleton;
    private boolean remoting;
    private String name;
    private int index;
    private String tag;
    private boolean typed;
    private Proxy proxy;
    private final Annotation[] annotations;
    private final AppContext context;
    private Set<ParameterizedType> genericList;
    private boolean isDoned;

    protected Set<ParameterizedType> genericList() {
        if (this.genericList == null) {
            this.genericList = new HashSet<ParameterizedType>();
        }
        return this.genericList;
    }

    protected boolean isNullOrGenericFrom(ParameterizedType checkType) {
        if (checkType == null) {
            return true;
        }
        if (Utils.isEmpty(this.genericList)) {
            return false;
        }
        for (ParameterizedType pt : this.genericList) {
            if (!GenericUtil.genericMatched(checkType, pt)) continue;
            return true;
        }
        return false;
    }

    public BeanWrap(AppContext context, Class<?> clz) {
        this(context, clz, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw) {
        this(context, clz, raw, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name) {
        this(context, clz, raw, name, false, null, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name, boolean typed) {
        this(context, clz, raw, name, typed, null, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name, boolean typed, String initMethodName, String destroyMethodName) {
        this(context, clz, raw, name, typed, initMethodName, destroyMethodName, null, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Constructor rawCtor, Object[] rawCtorArgs) {
        this(context, clz, null, null, false, null, null, rawCtor, rawCtorArgs);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name, boolean typed, String initMethodName, String destroyMethodName, Constructor rawCtor, Object[] rawCtorArgs) {
        this.context = context;
        this.clz = clz;
        this.name = name;
        this.typed = typed;
        this.rawCtor = rawCtor;
        this.rawCtorArgs = rawCtorArgs;
        Singleton anoS = clz.getAnnotation(Singleton.class);
        this.singleton = anoS == null || anoS.value();
        this.annotations = clz.getAnnotations();
        this.raw = raw == null ? (this.rawUnproxied = this._new()) : (this.rawUnproxied = raw);
        if (this.rawUnproxied != null) {
            this.rawClz = this.rawUnproxied.getClass();
        }
        this.tryInit(initMethodName, destroyMethodName);
    }

    public AppContext context() {
        return this.context;
    }

    public boolean isDoned() {
        return this.isDoned;
    }

    public void done() {
        this.isDoned = true;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public void proxySet(Proxy proxy) {
        this.proxy = proxy;
        if (this.raw != null && this.raw == this.rawUnproxied) {
            this.raw = proxy.getProxy(this, this.raw);
        }
    }

    public boolean singleton() {
        return this.singleton;
    }

    public void singletonSet(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean remoting() {
        return this.remoting;
    }

    public void remotingSet(boolean remoting) {
        this.remoting = remoting;
    }

    public Class<?> clz() {
        return this.clz;
    }

    public Method clzInit() {
        return this.lifecycle.initMethod();
    }

    public Method clzDestroy() {
        return this.lifecycle.destroyMethod();
    }

    public Constructor clzCtor() {
        return this.rawCtor;
    }

    public Object[] clzCtorArgs() {
        return this.rawCtorArgs;
    }

    public <T> T raw(boolean unproxied) {
        if (unproxied) {
            return (T)this.rawUnproxied;
        }
        return (T)this.raw;
    }

    public <T> T raw() {
        return this.raw(false);
    }

    public void rawSet(Object raw) {
        if (this.raw == null) {
            this.raw = raw;
        }
    }

    public Class<?> rawClz() {
        if (this.rawClz == null) {
            return this.clz;
        }
        return this.rawClz;
    }

    public String name() {
        return this.name;
    }

    public void nameSet(String name) {
        if (!this.isDoned()) {
            this.name = name;
        }
    }

    public int index() {
        return this.index;
    }

    public void indexSet(int index) {
        if (!this.isDoned()) {
            this.index = index;
        }
    }

    public String tag() {
        return this.tag;
    }

    public void tagSet(String tag) {
        if (!this.isDoned()) {
            this.tag = tag;
        }
    }

    public boolean typed() {
        return this.typed;
    }

    public void typedSet(boolean typed) {
        if (!this.isDoned()) {
            this.typed = typed;
        }
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T annotationGet(Class<T> annClz) {
        return this.clz.getAnnotation(annClz);
    }

    public boolean annotationHas(Class<? extends Annotation> annClz) {
        return this.clz.isAnnotationPresent(annClz);
    }

    public <T> T get() {
        return this.get(false);
    }

    public <T> T get(boolean unproxied) {
        if (unproxied) {
            if (this.singleton) {
                return (T)this.rawUnproxied;
            }
            return (T)this._new();
        }
        if (this.singleton) {
            return (T)this.raw;
        }
        return this.create();
    }

    public <T> T create() {
        Object bean = this._new();
        if (this.proxy != null) {
            bean = this.proxy.getProxy(this, bean);
        }
        return (T)bean;
    }

    protected Object _new() throws ConstructionException {
        if (this.clz.isInterface() || this.clz.isAnonymousClass() || Modifier.isAbstract(this.clz.getModifiers())) {
            return this.raw;
        }
        try {
            if (this.rawCtor == null) {
                this.rawCtor = this.rawClz().getDeclaredConstructor(new Class[0]);
                this.rawCtorArgs = new Object[0];
            }
            Object bean = ClassUtil.newInstance(this.rawCtor, this.rawCtorArgs);
            if (this.context != null) {
                this.context.beanInject(bean);
            }
            return bean;
        }
        catch (Throwable e) {
            if (e instanceof ConstructionException) {
                throw (ConstructionException)e;
            }
            throw new ConstructionException("Instantiation failure: " + this.clz.getTypeName(), e);
        }
    }

    protected void tryInit(String initMethodName, String destroyMethodName) {
        if (this.context != null && this.lifecycle == null) {
            this.lifecycle = new BeanWrapLifecycle(this, initMethodName, destroyMethodName);
            if (this.lifecycle.check()) {
                this.context.lifecycle(this.lifecycle.index() + 1, this.lifecycle);
                if (!this.singleton()) {
                    log.warn("Using lifecycle for non-singleton class is risky: " + this.rawClz().getName());
                }
            }
        }
    }

    @FunctionalInterface
    public static interface Proxy {
        public Object getProxy(BeanWrap var1, Object var2);
    }
}

