/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Predicate;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.core.wrap.ClassWrap;

public class ClassUtil {
    private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
    private static Predicate<Class<?>> SCAN_CLASSES_FILTER_DEF = clz -> true;

    public static boolean isNumberType(Class<?> clz) {
        if (clz.isPrimitive()) {
            return clz == Byte.TYPE || clz == Short.TYPE || clz == Integer.TYPE || clz == Long.TYPE || clz == Float.TYPE || clz == Double.TYPE;
        }
        return Number.class.isAssignableFrom(clz);
    }

    public static boolean hasClass(SupplierEx<Class<?>> test) {
        try {
            test.get();
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(null, className);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public static <T> T tryInstance(String className) {
        return ClassUtil.tryInstance(className, null);
    }

    public static <T> T tryInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(AppClassLoader.global(), className, prop);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className, null);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className, Properties prop) {
        Class<?> clz = ClassUtil.loadClass(classLoader, className);
        return ClassUtil.tryInstance(clz, prop);
    }

    public static <T> T tryInstance(Class<?> clz, Properties prop) {
        if (clz == null) {
            return null;
        }
        return ClassUtil.newInstance(clz, prop);
    }

    public static <T> T newInstance(Class<?> clz) throws ConstructionException {
        return ClassUtil.newInstance(clz, null);
    }

    public static <T> T newInstance(Class<?> clz, Properties prop) throws ConstructionException {
        try {
            if (prop == null) {
                return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)clz.getConstructor(Properties.class).newInstance(prop);
        }
        catch (Exception e) {
            throw new ConstructionException("Instantiation failure: " + clz.getName(), e);
        }
    }

    public static Object newInstance(Class<?> clz, Class<?>[] types, Object[] args) {
        try {
            Constructor<?> constructor = clz.getDeclaredConstructor(types);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ConstructionException("Instantiation failure: " + clz.getName(), e);
        }
    }

    public static Object newInstance(Constructor constructor, Object[] args) {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor is null");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ConstructionException("Instantiation failure: " + constructor.getDeclaringClass().getName(), e);
        }
    }

    public static ClassLoader resolveClassLoader(Type type) {
        ClassLoader cl;
        Class<?> clz;
        ClassLoader loader = AppClassLoader.global();
        if (type != null && (clz = ClassUtil.getTypeClass(type)) != Object.class && (cl = clz.getClassLoader()) != systemClassLoader) {
            loader = cl;
        }
        return loader;
    }

    public static Class<?> getTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getTypeClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Collection<Method> findPublicMethods(Class<?> clz) {
        return ClassWrap.get(clz).findPublicMethods();
    }

    public static Collection<Class<?>> scanClasses(String clzExpr) {
        return ClassUtil.scanClasses(AppClassLoader.global(), clzExpr, SCAN_CLASSES_FILTER_DEF);
    }

    public static Collection<Class<?>> scanClasses(String clzExpr, Predicate<Class<?>> clzFilter) {
        return ClassUtil.scanClasses(AppClassLoader.global(), clzExpr, clzFilter);
    }

    public static Collection<Class<?>> scanClasses(ClassLoader classLoader, String clzExpr) {
        return ClassUtil.scanClasses(classLoader, clzExpr, SCAN_CLASSES_FILTER_DEF);
    }

    public static Collection<Class<?>> scanClasses(ClassLoader classLoader, String clzExpr, Predicate<Class<?>> clzFilter) {
        int idx;
        ArrayList clzList = new ArrayList();
        if (clzExpr.indexOf(42) < 0) {
            if (clzExpr.endsWith(".class")) {
                Class<?> clz = ClassUtil.loadClass(classLoader, clzExpr = clzExpr.substring(0, clzExpr.length() - 6));
                if (clz != null && clzFilter.test(clz)) {
                    clzList.add(clz);
                }
                return clzList;
            }
            idx = clzExpr.lastIndexOf(46);
            if (idx > 0 && Character.isLowerCase(clzExpr.charAt(idx + 1))) {
                clzExpr = clzExpr + ".*";
            } else {
                Class<?> clz = ClassUtil.loadClass(classLoader, clzExpr);
                if (clz != null && clzFilter.test(clz)) {
                    clzList.add(clz);
                }
                return clzList;
            }
        }
        if (clzExpr.endsWith(".class")) {
            clzExpr = clzExpr.substring(0, clzExpr.length() - 6);
        } else {
            idx = clzExpr.lastIndexOf(46);
            if (idx > 0 && clzExpr.indexOf(42, idx) < 0 && Character.isLowerCase(clzExpr.charAt(idx + 1))) {
                clzExpr = clzExpr + ".*";
            }
        }
        clzExpr = clzExpr.replace('.', '/');
        clzExpr = clzExpr + ".class";
        ResourceUtil.scanResources(classLoader, clzExpr).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = ClassUtil.loadClass(classLoader, className = className.replace('/', '.'));
            if (clz != null && clzFilter.test(clz)) {
                clzList.add(clz);
            }
        });
        return clzList;
    }
}

