/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.noear.solon.annotation.To;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.convert.ConverterFactory;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderFactory;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConditionUtil;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.IndexUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ProxyBinder;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.core.util.TmplUtil;
import org.noear.solon.core.util.TypeMap;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.ConstructorWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.MethodKey;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.VarHolderOfParam;
import org.noear.solon.lang.Nullable;

public class AppContext
extends BeanContainer {
    private final Set<RankEntity<Lifecycle>> lifecycleBeans = new HashSet<RankEntity<Lifecycle>>();
    private final Map<MethodKey, MethodWrap> methodCached = new HashMap<MethodKey, MethodWrap>();
    private final Set<Class<?>> beanBuildedCached = new HashSet();
    private final Set<InjectGather> gatherSet = new HashSet<InjectGather>();
    private static final int build_bean_ofclass_state0 = 0;
    private static final int build_bean_ofclass_state1 = 1;
    private static final int build_bean_ofclass_state2 = 2;
    private boolean started;

    public AppContext() {
        this(Thread.currentThread().getContextClassLoader(), new Props());
    }

    public AppContext(ClassLoader classLoader, Props props) {
        this(Solon.app(), classLoader, props);
    }

    public AppContext(SolonApp app, ClassLoader classLoader, Props props) {
        super(app, classLoader, props);
        this.initialize();
        this.lifecycle(-95, () -> this.startInjectReview(0));
        this.lifecycle(-96, () -> this.startInjectReview(1));
    }

    public <T> AppContext onEvent(Class<T> type, EventListener<T> handler) {
        EventBus.subscribe(type, handler);
        return this;
    }

    public <T> AppContext onEvent(Class<T> type, int index, EventListener<T> handler) {
        EventBus.subscribe(type, index, handler);
        return this;
    }

    public MethodWrap methodGet(Method method) {
        return this.methodGet(method.getDeclaringClass(), method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodWrap methodGet(Class<?> clz, Method method) {
        MethodKey methodKey = new MethodKey(method, clz);
        MethodWrap mw = this.methodCached.get(methodKey);
        if (mw == null) {
            this.SYNC_LOCK.lock();
            try {
                mw = this.methodCached.get(methodKey);
                if (mw == null) {
                    mw = new MethodWrap(this, clz, method);
                    this.methodCached.put(methodKey, mw);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return mw;
    }

    public void methodForeach(Consumer<MethodWrap> action) {
        this.methodCached.values().forEach(action);
    }

    @Override
    public void clear() {
        super.clear();
        this.methodCached.clear();
        this.beanBuildedCached.clear();
        this.gatherSet.clear();
        this.lifecycleBeans.clear();
        this.started = false;
    }

    @Override
    protected BeanWrap wrapCreate(Class<?> type, Object bean, String name, boolean typed) {
        return new BeanWrap(this, type, bean, name, typed);
    }

    protected void initialize() {
        this.beanBuilderAdd(Configuration.class, (clz, bw, anno) -> {
            for (Annotation a1 : clz.getAnnotations()) {
                if (a1 instanceof Import) {
                    this.cfg().loadAdd((Import)a1);
                    this.beanImport((Import)a1);
                    continue;
                }
                if ((a1 = a1.annotationType().getAnnotation(Import.class)) == null) continue;
                this.cfg().loadAdd((Import)a1);
                this.beanImport((Import)a1);
            }
            this.beanInjectProperties(clz, bw.raw());
            for (Method m : ClassUtil.findPublicMethods(bw.clz())) {
                Bean ma = m.getAnnotation(Bean.class);
                if (ma == null) continue;
                this.tryBuildBeanOfMethod(bw, m, ma);
                if (Modifier.isPublic(m.getModifiers())) continue;
                LogUtil.global().warn("This @Bean method is not public: " + m.getDeclaringClass().getName() + ":" + m.getName());
            }
            this.beanDeliver(bw);
            this.beanRegisterSupI(clz, bw);
        });
        this.beanBuilderAdd(Component.class, (clz, bw, anno) -> {
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            bw.nameSet(beanName);
            bw.tagSet(anno.tag());
            bw.typedSet(anno.typed());
            bw.indexSet(anno.index());
            this.beanComponentized(bw, anno.delivered());
        });
        this.beanBuilderAdd(Remoting.class, (clz, bw, anno) -> {
            bw.remotingSet(true);
            this.beanRegister(bw, "", false);
            if (this.app() != null) {
                this.app().router().add(bw);
            }
        });
        this.beanBuilderAdd(Controller.class, (clz, bw, anno) -> {
            if (this.app() != null) {
                this.app().router().add(bw);
            }
        });
        this.beanInjectorAdd(Inject.class, (vh, anno) -> this.beanInject(vh, anno.value(), anno.required(), anno.autoRefreshed()));
        this.beanInterceptorAdd(To.class, inv -> {
            To anno;
            Object rst = inv.invoke();
            Context ctx = Context.current();
            if (ctx != null && (anno = inv.method().getAnnotation(To.class)).value().length > 0) {
                ArrayList<String> list = new ArrayList<String>(anno.value().length);
                for (String val : anno.value()) {
                    list.add(TmplUtil.parse(val, inv, rst));
                }
                ctx.attrSet("ATTR_TO", list);
            }
            return rst;
        });
    }

    protected void beanComponentized(BeanWrap bw, boolean delivered) {
        this.beanExtractOrProxy(bw);
        if (delivered) {
            this.beanDeliver(bw);
        }
        this.beanRegister(bw, bw.name(), bw.typed());
        if (bw.singleton()) {
            this.wrapPublish(bw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beanInject(VarHolder vh, String name, boolean required, boolean autoRefreshed) {
        super.beanInject(vh, name, required, autoRefreshed);
        if (vh.isDone()) {
            return;
        }
        try {
            if (Utils.isEmpty(name) && vh.getGenericType() != null) {
                if (List.class == vh.getType()) {
                    String typeFilter;
                    Type type;
                    Type tmp = vh.getGenericType().getActualTypeArguments()[0];
                    if (tmp instanceof ParameterizedType) {
                        type = ((ParameterizedType)tmp).getRawType();
                        typeFilter = tmp.getTypeName();
                    } else {
                        type = tmp;
                        typeFilter = null;
                    }
                    if (type instanceof Class) {
                        if (vh.isField()) {
                            vh.required(required);
                        } else {
                            vh.required(false);
                            vh.setDependencyType((Class)type);
                        }
                        vh.setValueDefault(() -> this.getBeansOfType((Class)type, typeFilter));
                    }
                } else if (Map.class == vh.getType()) {
                    String valFilter;
                    Type valType;
                    Type valTmp = vh.getGenericType().getActualTypeArguments()[1];
                    Type keyType = vh.getGenericType().getActualTypeArguments()[0];
                    if (valTmp instanceof ParameterizedType) {
                        valType = ((ParameterizedType)valTmp).getRawType();
                        valFilter = valTmp.getTypeName();
                    } else {
                        valType = valTmp;
                        valFilter = null;
                    }
                    if (String.class == keyType && valType instanceof Class) {
                        if (vh.isField()) {
                            vh.required(required);
                        } else {
                            vh.required(false);
                            vh.setDependencyType((Class)valType);
                        }
                        vh.setValueDefault(() -> this.getBeansMapOfType((Class)valType, valFilter));
                    }
                }
            }
        }
        finally {
            if (this.isStarted()) {
                vh.commit();
            }
        }
    }

    public void beanDeliver(BeanWrap bw) {
        Mapping mapping;
        if (bw.raw() == null) {
            return;
        }
        if (bw.raw() instanceof Plugin) {
            throw new IllegalStateException("'Plugin' cannot be component, please use 'LifecycleBean': " + bw.clz().getName());
        }
        String singletonHint = null;
        if (bw.raw() instanceof LifecycleBean) {
            int index = bw.index();
            if (index == 0) {
                index = IndexUtil.buildLifecycleIndex(bw.rawClz());
            }
            this.lifecycle(index + 1, (LifecycleBean)bw.raw());
            singletonHint = "LifecycleBean";
        }
        if (bw.raw() instanceof EventListener) {
            this.addEventListener(bw.clz(), bw);
            singletonHint = "EventListener";
        }
        if (this.app() == null) {
            return;
        }
        if (bw.raw() instanceof LoadBalance.Factory) {
            this.app().factoryManager().loadBalanceFactory((LoadBalance.Factory)bw.raw());
            singletonHint = "LoadBalance.Factory";
        }
        if (bw.raw() instanceof Handler && (mapping = bw.clz().getAnnotation(Mapping.class)) != null) {
            this.app().router().add(bw);
            singletonHint = "Handler";
        }
        if (bw.raw() instanceof Render) {
            this.app().renderManager().register(bw.name(), (Render)bw.raw());
            singletonHint = "Render";
        }
        if (bw.raw() instanceof RenderFactory) {
            this.app().renderManager().register((RenderFactory)bw.raw());
            singletonHint = "RenderFactory";
        }
        if (bw.raw() instanceof Filter) {
            this.app().filter(bw.index(), (Filter)bw.raw());
            singletonHint = "Filter";
        }
        if (bw.raw() instanceof RouterInterceptor) {
            this.app().routerInterceptor(bw.index(), (RouterInterceptor)bw.raw());
            singletonHint = "RouterInterceptor";
        }
        if (bw.raw() instanceof ActionReturnHandler) {
            this.app().chainManager().addReturnHandler((ActionReturnHandler)bw.raw());
            singletonHint = "ActionReturnHandler";
        }
        if (bw.raw() instanceof ActionExecuteHandler) {
            this.app().chainManager().addExecuteHandler((ActionExecuteHandler)bw.raw());
            singletonHint = "ActionExecuteHandler";
        }
        if (bw.raw() instanceof Converter) {
            Converter c = (Converter)bw.raw();
            this.app().converterManager().register(c);
            singletonHint = "Converter";
        }
        if (bw.raw() instanceof ConverterFactory) {
            ConverterFactory cf = (ConverterFactory)bw.raw();
            this.app().converterManager().register(cf);
            singletonHint = "ConverterFactory";
        }
        if (!bw.singleton() && singletonHint != null) {
            LogUtil.global().warn(singletonHint + " does not support @Singleton(false), class=" + bw.clz().getName());
        }
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        Class<?>[] ets = GenericUtil.resolveTypeArguments(clz, EventListener.class);
        if (ets != null && ets.length > 0) {
            EventBus.subscribe(ets[0], bw.index(), (EventListener)bw.raw());
        }
    }

    public void beanExtractOrProxy(BeanWrap bw) {
        this.beanExtractOrProxy(bw, true, true);
    }

    public void beanExtractOrProxy(BeanWrap bw, boolean tryExtract, boolean tryProxy) {
        if (bw == null) {
            return;
        }
        boolean enableProxy = false;
        if (this.beanExtractors.size() > 0 || this.beanInterceptors.size() > 0) {
            ClassWrap clzWrap = ClassWrap.get(bw.clz());
            for (Method m : clzWrap.getMethods()) {
                for (Annotation a : m.getAnnotations()) {
                    BeanExtractor be;
                    if (tryExtract && (be = (BeanExtractor)this.beanExtractors.get(a.annotationType())) != null) {
                        try {
                            be.doExtract(bw, m, a);
                        }
                        catch (Throwable e) {
                            e = Utils.throwableUnwrap(e);
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException(e);
                        }
                    }
                    if (!tryProxy) continue;
                    enableProxy = enableProxy || this.beanInterceptorHas(a);
                }
            }
        }
        if (tryProxy) {
            boolean bl = enableProxy = enableProxy || this.beanInterceptorHas(bw.clz());
            if (enableProxy) {
                ProxyBinder.global().binding(bw);
            }
        }
    }

    public void beanInject(Object obj) {
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        ArrayList<FieldWrap> fwList = new ArrayList<FieldWrap>();
        for (FieldWrap fw : clzWrap.getAllFieldWraps()) {
            if (fw.getAnnoS().length <= 0) continue;
            fwList.add(fw);
        }
        for (FieldWrap fw : clzWrap.getStaticFieldWraps()) {
            if (fw.getAnnoS().length <= 0) continue;
            fwList.add(fw);
        }
        if (fwList.size() != 0) {
            InjectGather gather = new InjectGather(0, clzWrap.clz(), true, fwList.size(), null);
            this.gatherSet.add(gather);
            for (FieldWrap fw : fwList) {
                VarHolder vh = fw.holder(this, obj, gather);
                gather.add(vh);
                this.tryInject(vh, fw.getAnnoS());
            }
        }
    }

    public void beanExclude(Class<?> ... clzs) {
        for (Class<?> clz : clzs) {
            this.beanBuildedCached.add(clz);
        }
    }

    public void beanImport(Import anno) {
        if (anno != null) {
            for (Class<?> c1 : anno.value()) {
                this.beanMake(c1);
            }
            for (Class<?> c1 : anno.classes()) {
                this.beanMake(c1);
            }
            for (String p1 : anno.scanPackages()) {
                this.beanScan(p1);
            }
            for (Class<?> s1 : anno.scanPackageClasses()) {
                this.beanScan(s1);
            }
        }
    }

    public void beanScan(Class<?> source) {
        if (source.getPackage() != null) {
            this.beanScan(source.getClassLoader(), source.getPackage().getName());
        }
    }

    public void beanScan(String basePackage) {
        this.beanScan(this.getClassLoader(), basePackage);
    }

    public void beanScan(ClassLoader classLoader, String basePackage) {
        if (Utils.isEmpty(basePackage)) {
            return;
        }
        if (classLoader == null) {
            return;
        }
        String dir = basePackage.replace('.', '/');
        ScanUtil.scan(classLoader, dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = ClassUtil.loadClass(classLoader, className = className.replace('/', '.'));
            if (clz != null) {
                this.tryBuildBeanOfClass(clz);
            }
        });
    }

    @Nullable
    public BeanWrap beanMake(Class<?> clz) {
        int state = this.tryBuildBeanOfClass(clz);
        if (state == 1) {
            return null;
        }
        if (state == 2) {
            return this.getWrap(clz);
        }
        return this.wrapAndPut(clz);
    }

    protected void tryInject(VarHolder vh, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector injector;
            TypeMap biMap = (TypeMap)this.beanInjectors.get(a.annotationType());
            if (biMap == null || (injector = (BeanInjector)biMap.get(vh.getType())) == null) continue;
            injector.doInject(vh, a);
            return;
        }
        vh.setValue(null);
    }

    protected void tryBuildBeanOfMethod(BeanWrap bw, Method m, Bean ma) throws Throwable {
        if (NativeDetector.isAotRuntime()) {
            this.methodGet(bw.rawClz(), m);
        }
        Condition mc = m.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissingBean(mc)) {
            this.lifecycle(-98, ma.priority(), () -> this.tryBuildBeanOfMethod0(bw, m, ma, mc));
        } else {
            this.tryBuildBeanOfMethod0(bw, m, ma, mc);
        }
    }

    private void tryBuildBeanOfMethod0(BeanWrap bw, Method m, Bean ma, Condition mc) throws Throwable {
        if (!ConditionUtil.test(this, mc)) {
            return;
        }
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        MethodWrap mWrap = this.methodGet(bw.rawClz(), m);
        if (ConditionUtil.ifBean(mc)) {
            ConditionUtil.onBeanRun(mc, this, () -> this.tryBuildBeanOfMethod1(ma, mWrap, bw));
        } else {
            this.tryBuildBeanOfMethod1(ma, mWrap, bw);
        }
    }

    private void tryBuildBeanOfMethod1(Bean anno, MethodWrap mWrap, BeanWrap bw) throws Throwable {
        if (mWrap.getParamWraps().length == 0) {
            this.tryBuildBeanOfMethod2(anno, mWrap, bw, new Object[0]);
        } else {
            this.tryMethodParamsGather(bw.context(), 1, mWrap.getReturnType(), mWrap.getParamWraps(), args2 -> RunUtil.runOrThrow(() -> this.tryBuildBeanOfMethod2(anno, mWrap, bw, (Object[])args2)));
        }
    }

    protected void tryMethodParamsGather(AppContext context, int label, Class<?> outType, ParamWrap[] paramAry, ConsumerEx<Object[]> completionConsumer) {
        InjectGather gather = new InjectGather(label, outType, true, paramAry.length, args2 -> completionConsumer.accept((Object[])args2));
        this.gatherSet.add(gather);
        for (ParamWrap pw1 : paramAry) {
            VarHolderOfParam vh = new VarHolderOfParam(context, pw1, gather);
            gather.add(vh);
            if (pw1.getAnnoS().length == 0) {
                this.beanInject(vh, null, true, false);
                continue;
            }
            this.tryInject(vh, pw1.getAnnoS());
        }
    }

    protected void tryBuildBeanOfMethod2(Bean anno, MethodWrap mWrap, BeanWrap bw, Object[] args) {
        try {
            Object raw = mWrap.invoke(bw.raw(), args);
            if (raw != null) {
                Class<?> beanClz = mWrap.getReturnType();
                ParameterizedType beanGtp = mWrap.getGenericReturnType();
                BeanWrap m_bw = null;
                if (raw instanceof BeanWrap) {
                    m_bw = (BeanWrap)raw;
                } else {
                    if (anno.injected()) {
                        this.beanInject(raw);
                    }
                    m_bw = new BeanWrap(this, beanClz, raw, null, false, anno.initMethod(), anno.destroyMethod());
                }
                String beanName = Utils.annoAlias(anno.value(), anno.name());
                m_bw.nameSet(beanName);
                m_bw.tagSet(anno.tag());
                m_bw.typedSet(anno.typed());
                m_bw.indexSet(anno.index());
                m_bw.done();
                if (anno.delivered()) {
                    this.beanDeliver(m_bw);
                }
                this.beanRegister(m_bw, beanName, anno.typed());
                if (beanGtp instanceof ParameterizedType) {
                    this.putWrap(beanGtp.getTypeName(), m_bw);
                }
                this.wrapPublish(m_bw);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Build bean of method failed: " + mWrap.getMethod(), ex);
        }
    }

    protected int tryBuildBeanOfClass(Class<?> clz) {
        Condition cc = clz.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissingBean(cc)) {
            this.lifecycle(-99, () -> this.tryBuildBeanOfClass0(clz, cc));
            return 1;
        }
        return this.tryBuildBeanOfClass0(clz, cc);
    }

    private int tryBuildBeanOfClass0(Class<?> clz, Condition cc) {
        if (!ConditionUtil.test(this, cc)) {
            return 1;
        }
        if (ConditionUtil.ifBean(cc)) {
            ConditionUtil.onBeanRun(cc, this, () -> this.tryBuildBeanOfClass1(clz));
            return 1;
        }
        return this.tryBuildBeanOfClass1(clz);
    }

    private int tryBuildBeanOfClass1(Class<?> clz) {
        Annotation[] annS = clz.getAnnotations();
        int state = 0;
        if (annS.length > 0) {
            if (this.beanBuildedCached.contains(clz)) {
                return 2;
            }
            this.beanBuildedCached.add(clz);
            for (Annotation a : annS) {
                BeanBuilder builder;
                TypeMap bbMap = (TypeMap)this.beanBuilders.get(a.annotationType());
                if (bbMap == null || (builder = (BeanBuilder)bbMap.get(clz)) == null) continue;
                try {
                    state = 2;
                    this.tryBuildBeanOfClass2(clz, builder, a);
                }
                catch (Throwable e) {
                    e = Utils.throwableUnwrap(e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
        }
        return state;
    }

    private void tryBuildBeanOfClass2(Class<?> clz, BeanBuilder builder, Annotation anno) throws Throwable {
        Constructor<?> c1 = !clz.isInterface() ? clz.getDeclaredConstructors()[0] : null;
        if (c1 == null || c1.getParameterCount() == 0) {
            this.tryBuildBeanOfClass3(clz, builder, anno, null, null);
        } else {
            ConstructorWrap cw = new ConstructorWrap(clz, c1);
            this.tryMethodParamsGather(this, 2, clz, cw.getParamWraps(), args2 -> this.tryBuildBeanOfClass3(clz, builder, anno, c1, (Object[])args2));
        }
    }

    private void tryBuildBeanOfClass3(Class<?> clz, BeanBuilder builder, Annotation anno, Constructor rawCon, Object[] rawConArgs) throws Throwable {
        BeanWrap bw = new BeanWrap(this, clz, rawCon, rawConArgs);
        builder.doBuild(clz, bw, anno);
        bw.done();
        this.putWrap(clz, bw);
    }

    public void lifecycle(LifecycleBean lifecycle) {
        this.lifecycle(0, (Lifecycle)lifecycle);
    }

    public void lifecycle(int index, LifecycleBean lifecycle) {
        this.lifecycle(index, (Lifecycle)lifecycle);
    }

    @Override
    public void lifecycle(Lifecycle lifecycle) {
        this.lifecycle(0, lifecycle);
    }

    @Override
    public void lifecycle(int index, Lifecycle lifecycle) {
        this.lifecycle(index, 0, lifecycle);
    }

    @Override
    public void lifecycle(int index, int priority, Lifecycle lifecycle) {
        this.lifecycleBeans.add(new RankEntity<Lifecycle>(lifecycle, index, priority));
        if (this.started) {
            RunUtil.runOrThrow(lifecycle::start);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
        try {
            this.startBeanLifecycle();
            this.startInjectReview(2);
            this.postStartBeanLifecycle();
        }
        catch (Throwable e) {
            throw new IllegalStateException("AppContext start failed", e);
        }
    }

    private void startBeanLifecycle() throws Throwable {
        ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
        Collections.sort(beans);
        for (RankEntity rankEntity : beans) {
            ((Lifecycle)rankEntity.target).start();
        }
    }

    private void postStartBeanLifecycle() throws Throwable {
        ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
        Collections.sort(beans);
        for (RankEntity rankEntity : beans) {
            ((Lifecycle)rankEntity.target).postStart();
        }
    }

    private void startInjectReview(int sel) throws Throwable {
        block5: {
            List<InjectGather> gatherList = null;
            gatherList = sel == 0 ? this.gatherSet.stream().filter(g1 -> !g1.isDone() && !g1.isMethod()).collect(Collectors.toList()) : (sel == 1 ? this.gatherSet.stream().filter(g1 -> !g1.isDone() && g1.isMethod()).collect(Collectors.toList()) : this.gatherSet.stream().filter(g1 -> !g1.isDone()).collect(Collectors.toList()));
            if (gatherList.size() <= 0) break block5;
            if (sel > 0) {
                for (InjectGather gather : gatherList) {
                    IndexUtil.buildGatherIndex(gather, gatherList);
                }
                Collections.sort(gatherList);
                for (InjectGather g12 : gatherList) {
                    g12.check();
                }
            } else {
                for (InjectGather gather : gatherList) {
                    gather.commit();
                }
            }
        }
    }

    public void prestop() {
        this.started = false;
        try {
            ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
            Collections.sort(beans);
            for (RankEntity rankEntity : beans) {
                try {
                    ((Lifecycle)rankEntity.target).preStop();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ignored) {
            LogUtil.global().warn("AppContext prestop error", ignored);
        }
    }

    public void stop() {
        this.started = false;
        try {
            ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
            Collections.sort(beans);
            for (RankEntity rankEntity : beans) {
                try {
                    ((Lifecycle)rankEntity.target).stop();
                }
                catch (Throwable throwable) {}
            }
            this.beanStop0();
        }
        catch (Throwable ignored) {
            LogUtil.global().warn("AppContext stop error", ignored);
        }
    }
}

