/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.NamedThreadFactory;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.core.util.ThreadsUtil;

public class RunUtil {
    private static ExecutorService asyncExecutor;
    private static ScheduledExecutorService scheduledExecutor;

    @Deprecated
    public static void setParallelExecutor(ExecutorService parallelExecutor) {
    }

    public static void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        if (scheduledExecutor != null) {
            ScheduledExecutorService old = RunUtil.scheduledExecutor;
            RunUtil.scheduledExecutor = scheduledExecutor;
            old.shutdown();
        }
    }

    public static void setAsyncExecutor(ExecutorService asyncExecutor) {
        if (asyncExecutor != null) {
            ExecutorService old = RunUtil.asyncExecutor;
            RunUtil.asyncExecutor = asyncExecutor;
            old.shutdown();
        }
    }

    public static void runOrThrow(RunnableEx task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void runAndTry(RunnableEx task) {
        try {
            task.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Deprecated
    public static Future<?> parallel(Runnable task) {
        return asyncExecutor.submit(task);
    }

    @Deprecated
    public static <T> Future<T> parallel(Callable<T> task) {
        return asyncExecutor.submit(task);
    }

    public static CompletableFuture<Void> async(Runnable task) {
        return CompletableFuture.runAsync(task, asyncExecutor);
    }

    public static <U> CompletableFuture<U> async(Supplier<U> task) {
        return CompletableFuture.supplyAsync(task, asyncExecutor);
    }

    public static CompletableFuture<Void> asyncAndTry(RunnableEx task) {
        return CompletableFuture.runAsync(() -> RunUtil.runAndTry(task), asyncExecutor);
    }

    public static ScheduledFuture<?> delay(Runnable task, long millis) {
        return scheduledExecutor.schedule(task, millis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> delayAndRepeat(Runnable task, long millis) {
        return scheduledExecutor.scheduleWithFixedDelay(task, 1000L, millis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long millisPeriod) {
        return scheduledExecutor.scheduleAtFixedRate(task, initialDelay, millisPeriod, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long millisDelay) {
        return scheduledExecutor.scheduleWithFixedDelay(task, initialDelay, millisDelay, TimeUnit.MILLISECONDS);
    }

    static {
        if (Solon.app() != null && Solon.cfg().isEnabledVirtualThreads()) {
            asyncExecutor = ThreadsUtil.newVirtualThreadPerTaskExecutor();
        } else {
            int asyncPoolSize = Runtime.getRuntime().availableProcessors() * 2;
            asyncExecutor = new ThreadPoolExecutor(0, asyncPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Solon-executor-"));
        }
        int scheduledPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        scheduledExecutor = new ScheduledThreadPoolExecutor(scheduledPoolSize, new NamedThreadFactory("Solon-scheduledExecutor-"));
    }
}

