/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.Solon;
import org.noear.solon.core.ChainManager;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.Router;

public class RouterHandler
implements Handler {
    private Router router;
    private ChainManager chainManager;

    public RouterHandler(Router router, ChainManager chainManager) {
        this.router = router;
        this.chainManager = chainManager;
    }

    protected boolean handleMain(Handler h, Context ctx) throws Throwable {
        if (h != null) {
            Solon.app().chainManager().refreshSessionState(ctx);
            h.handle(ctx);
            return ctx.status() != 404;
        }
        int code = ctx.attrOrDefault("mainStatus", 404);
        if (code == 405) {
            throw new StatusException("Method Not Allowed: " + ctx.method() + " " + ctx.pathNew(), code);
        }
        throw new StatusException("Not Found: " + ctx.method() + " " + ctx.pathNew(), code);
    }

    private void handle1(Context x) throws Throwable {
        try {
            if (!x.getHandled()) {
                Handler mainHandler = x.mainHandler();
                x.setHandled(this.handleMain(mainHandler, x));
            }
        }
        catch (Throwable e) {
            if (x.errors == null) {
                x.errors = e;
            }
            throw e;
        }
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (x.getHandled()) {
            return;
        }
        Handler mainHandler = this.router.matchMain(x);
        if (mainHandler instanceof Action) {
            x.attrSet("action", mainHandler);
        }
        this.chainManager.doIntercept(x, mainHandler, this::handle1);
    }
}

