/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Destroy;
import org.noear.solon.annotation.Init;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.util.IndexUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.wrap.ClassWrap;

class BeanWrapLifecycle
implements LifecycleBean {
    private BeanWrap bw;
    private Method initMethod;
    private int initIndex;
    private Method destroyMethod;

    public BeanWrapLifecycle(BeanWrap bw) {
        this.bw = bw;
    }

    public Method initMethod() {
        return this.initMethod;
    }

    public Method destroyMethod() {
        return this.destroyMethod;
    }

    public boolean check() {
        boolean isOk;
        if (this.bw.raw() == null) {
            return false;
        }
        ClassWrap clzWrap = ClassWrap.get(this.bw.rawClz());
        for (Method m : clzWrap.getDeclaredMethods()) {
            Init initAnno = m.getAnnotation(Init.class);
            if (initAnno != null) {
                if (m.getParameters().length == 0) {
                    this.initMethod = m;
                    this.initMethod.setAccessible(true);
                    this.initIndex = initAnno.index();
                }
            } else {
                Destroy destroyAnno = m.getAnnotation(Destroy.class);
                if (destroyAnno != null && m.getParameters().length == 0) {
                    this.destroyMethod = m;
                    this.destroyMethod.setAccessible(true);
                }
            }
            if (this.initMethod != null && this.destroyMethod != null) break;
        }
        if (this.initMethod != null && this.initIndex == 0) {
            this.initIndex = IndexUtil.buildLifecycleIndex(this.bw.rawClz());
        }
        boolean bl = isOk = this.initMethod != null || this.destroyMethod != null;
        if (isOk && this.bw.raw() instanceof LifecycleBean) {
            LogUtil.global().warn("LifecycleBean not support @Init & @Destroy, class=" + this.bw.rawClz().getName());
            return false;
        }
        return isOk;
    }

    public int index() {
        return this.initIndex;
    }

    @Override
    public void start() throws Throwable {
        if (this.initMethod != null) {
            try {
                this.initMethod.invoke(this.bw.raw(), new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                throw Utils.throwableUnwrap(e2);
            }
        }
    }

    @Override
    public void stop() throws Throwable {
        if (this.destroyMethod != null) {
            try {
                this.destroyMethod.invoke(this.bw.raw(), new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                throw Utils.throwableUnwrap(e2);
            }
        }
    }
}

