/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> cached = new ConcurrentHashMap();
    private final Class<?> _clz;
    private final Method[] declaredMethods;
    private final Method[] methods;
    private final List<FieldWrap> declaredFieldWraps;
    private final Map<String, FieldWrap> fieldWrapsMap;
    private boolean _recordable;
    private Constructor _recordConstructor;
    private List<ParamWrap> _recordParams;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassWrap get(Class<?> clz) {
        ClassWrap cw = cached.get(clz);
        if (cw == null) {
            Class<?> clazz = clz;
            synchronized (clazz) {
                cw = cached.get(clz);
                if (cw == null) {
                    cw = new ClassWrap(clz);
                    cached.put(clz, cw);
                }
            }
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        this._clz = clz;
        this._recordable = true;
        this.declaredMethods = ReflectUtil.getDeclaredMethods(clz);
        this.methods = ReflectUtil.getMethods(clz);
        this.declaredFieldWraps = new ArrayList<FieldWrap>();
        this.fieldWrapsMap = new LinkedHashMap<String, FieldWrap>();
        this.doScanAllFields(clz, this.fieldWrapsMap::containsKey, this.fieldWrapsMap::put);
        for (Field field : ReflectUtil.getDeclaredFields(clz)) {
            FieldWrap fw = this.fieldWrapsMap.get(field.getName());
            if (fw == null) continue;
            this.declaredFieldWraps.add(fw);
        }
        if (this.declaredFieldWraps.size() == 0) {
            this._recordable = false;
        }
        if (this._recordable) {
            this._recordConstructor = clz.getDeclaredConstructors()[0];
            this._recordParams = new ArrayList<ParamWrap>();
            for (AnnotatedElement annotatedElement : this._recordConstructor.getParameters()) {
                this._recordParams.add(new ParamWrap((Parameter)annotatedElement));
            }
        }
    }

    public Class<?> clz() {
        return this._clz;
    }

    public Map<String, FieldWrap> getFieldWraps() {
        return Collections.unmodifiableMap(this.fieldWrapsMap);
    }

    @Deprecated
    public Map<String, FieldWrap> getFieldAllWraps() {
        return this.getFieldWraps();
    }

    public FieldWrap getFieldWrap(String field) {
        return this.fieldWrapsMap.get(field);
    }

    public Method[] getDeclaredMethods() {
        return this.declaredMethods;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public boolean recordable() {
        return this._recordable;
    }

    public Constructor recordConstructor() {
        return this._recordConstructor;
    }

    public List<ParamWrap> recordParams() {
        return this._recordParams;
    }

    public <T> T newBy(Properties data) {
        try {
            Constructor<?> constructor = this.clz().getConstructor(Properties.class);
            if (constructor != null) {
                return (T)constructor.newInstance(data);
            }
        }
        catch (Throwable throwable) {
        }
        return this.newBy(data::getProperty);
    }

    public <T> T newBy(Function<String, String> data) {
        return this.newBy(data, null);
    }

    public <T> T newBy(Function<String, String> data, Context ctx) {
        try {
            if (this.recordable()) {
                List<ParamWrap> argsP = this.recordParams();
                Object[] argsV = new Object[argsP.size()];
                for (int i = 0; i < argsP.size(); ++i) {
                    Object val;
                    ParamWrap p = argsP.get(i);
                    String key = p.getName();
                    String val0 = data.apply(key);
                    argsV[i] = val0 != null ? (val = ConvertUtil.to(p, val0, ctx)) : (p.getType() == UploadedFile.class ? ctx.file(key) : null);
                }
                Object obj = this.recordConstructor().newInstance(argsV);
                return obj;
            }
            Object obj = ClassUtil.newInstance(this.clz());
            this.doFill(obj, data, ctx);
            return obj;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void fill(Object bean, Function<String, String> data) {
        try {
            this.doFill(bean, data, null);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void doFill(Object bean, Function<String, String> data, Context ctx) throws Exception {
        if (this.fieldWrapsMap.isEmpty() && NativeDetector.inNativeImage()) {
            LogUtil.global().warn(String.format("Class: %s don't have any field, can't fill data. you should use: nativeMetadata.registerField(field) at aot runtime.", this._clz.getName()));
        }
        for (Map.Entry<String, FieldWrap> kv : this.fieldWrapsMap.entrySet()) {
            UploadedFile file1;
            String key = kv.getKey();
            String val0 = data.apply(key);
            FieldWrap fw = kv.getValue();
            if (val0 != null) {
                Object val = ConvertUtil.to(fw.getDescriptor(), val0, ctx);
                fw.setValue(bean, val);
                continue;
            }
            if (ctx == null || fw.type != UploadedFile.class || (file1 = ctx.file(key)) == null) continue;
            fw.setValue(bean, file1);
        }
    }

    private void doScanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : ReflectUtil.getDeclaredFields(clz)) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || checker.test(f.getName())) continue;
            this._recordable &= Modifier.isFinal(mod);
            consumer.accept(f.getName(), new FieldWrap(this._clz, f, Modifier.isFinal(mod)));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            this.doScanAllFields(sup, checker, consumer);
        }
    }
}

