/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.core.util.RunUtil;

public class LogUtil {
    private static LogUtil global = (LogUtil)ClassUtil.tryInstance("org.noear.solon.extend.impl.LogUtilExt");

    public static LogUtil global() {
        return global;
    }

    public void trace(String content) {
        System.out.print("[Solon] ");
        PrintUtil.purpleln(content);
    }

    public void debugAsync(String content) {
        RunUtil.async(() -> this.debug(content));
    }

    public void debug(String content) {
        System.out.print("[Solon] ");
        PrintUtil.blueln(content);
    }

    public void infoAsync(String content) {
        RunUtil.async(() -> this.info(content));
    }

    public void info(String content) {
        System.out.println("[Solon] " + content);
    }

    public void warn(String content) {
        this.warn(content, null);
    }

    public void warn(String content, Throwable throwable) {
        System.out.print("[Solon] ");
        PrintUtil.yellowln("WARN: " + content);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public void error(String content) {
        this.error(content, null);
    }

    public void error(String content, Throwable throwable) {
        System.out.print("[Solon] ");
        PrintUtil.redln("ERROR: " + content);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    static {
        if (global == null) {
            global = new LogUtil();
        }
    }
}

