/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.message;

import java.io.IOException;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;

public class ContextPathListener
implements Listener {
    private final String contextPath0;
    private final String contextPath1;
    private final boolean forced;

    public ContextPathListener(boolean forced) {
        this(Solon.cfg().serverContextPath(), forced);
    }

    public ContextPathListener(String contextPath, boolean forced) {
        this.forced = forced;
        if (Utils.isEmpty(contextPath)) {
            this.contextPath0 = null;
            this.contextPath1 = null;
        } else {
            String newPath = null;
            newPath = contextPath.endsWith("/") ? contextPath : contextPath + "/";
            this.contextPath1 = newPath.startsWith("/") ? newPath : "/" + newPath;
            this.contextPath0 = this.contextPath1.substring(0, this.contextPath1.length() - 1);
        }
    }

    @Override
    public void onOpen(Session session) {
        if (this.contextPath0 != null) {
            if (session.pathNew().equals(this.contextPath0)) {
                session.pathNew("/");
            } else if (session.pathNew().startsWith(this.contextPath1)) {
                session.pathNew(session.pathNew().substring(this.contextPath1.length() - 1));
            } else if (this.forced) {
                try {
                    session.close();
                }
                catch (IOException e) {
                    EventBus.publishTry(e);
                }
            }
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
    }
}

