/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.AnnotatedElement;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Cookie;
import org.noear.solon.annotation.Header;
import org.noear.solon.annotation.Param;
import org.noear.solon.annotation.Path;
import org.noear.solon.annotation.PathVar;
import org.noear.solon.core.wrap.VarDeclarer;

public abstract class VarDeclarerBase
implements VarDeclarer {
    private AnnotatedElement element;
    private String name;
    private String defaultValue;
    private boolean isRequiredInput;
    private boolean isRequiredBody;
    private boolean isRequiredHeader;
    private boolean isRequiredCookie;
    private boolean isRequiredPath;

    @Override
    public boolean isRequiredBody() {
        return this.isRequiredBody;
    }

    @Override
    public boolean isRequiredHeader() {
        return this.isRequiredHeader;
    }

    @Override
    public boolean isRequiredCookie() {
        return this.isRequiredCookie;
    }

    @Override
    public boolean isRequiredPath() {
        return this.isRequiredPath;
    }

    @Override
    public boolean isRequiredInput() {
        return this.isRequiredInput;
    }

    @Override
    public String getRequiredHint() {
        if (this.isRequiredHeader) {
            return "Required header @" + this.getName();
        }
        if (this.isRequiredCookie) {
            return "Required cookie @" + this.getName();
        }
        return "Required parameter @" + this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public VarDeclarerBase(AnnotatedElement element, String name) {
        this.element = element;
        this.name = name;
    }

    protected void init() {
        if (!(this.resolveBody() || this.resolveParam() || this.resolvePathVar() || this.resolvePath() || this.resolveHeader())) {
            this.resolveCookie();
        }
    }

    private boolean resolveBody() {
        Body bodyAnno = this.element.getAnnotation(Body.class);
        if (bodyAnno == null) {
            return false;
        }
        this.isRequiredBody = true;
        return true;
    }

    private boolean resolveParam() {
        Param paramAnno = this.element.getAnnotation(Param.class);
        if (paramAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(paramAnno.value(), paramAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(paramAnno.defaultValue())) {
            this.defaultValue = paramAnno.defaultValue();
        }
        this.isRequiredInput = paramAnno.required();
        return true;
    }

    @Deprecated
    private boolean resolvePathVar() {
        PathVar paramAnno = this.element.getAnnotation(PathVar.class);
        if (paramAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(paramAnno.value(), paramAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        this.isRequiredPath = true;
        this.isRequiredInput = true;
        return true;
    }

    private boolean resolvePath() {
        Path paramAnno = this.element.getAnnotation(Path.class);
        if (paramAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(paramAnno.value(), paramAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        this.isRequiredPath = true;
        this.isRequiredInput = true;
        return true;
    }

    private boolean resolveHeader() {
        Header headerAnno = this.element.getAnnotation(Header.class);
        if (headerAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(headerAnno.value(), headerAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(headerAnno.defaultValue())) {
            this.defaultValue = headerAnno.defaultValue();
        }
        this.isRequiredInput = headerAnno.required();
        this.isRequiredHeader = true;
        return true;
    }

    private boolean resolveCookie() {
        Cookie cookieAnno = this.element.getAnnotation(Cookie.class);
        if (cookieAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(cookieAnno.value(), cookieAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(cookieAnno.defaultValue())) {
            this.defaultValue = cookieAnno.defaultValue();
        }
        this.isRequiredInput = cookieAnno.required();
        this.isRequiredCookie = true;
        return true;
    }
}

