/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.FilterLimiter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.PathLimiter;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChainImpl;
import org.noear.solon.core.route.RouterInterceptorLimiter;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.lang.Nullable;

public class ChainManager {
    private final List<RankEntity<Filter>> _filterNodes = new ArrayList<RankEntity<Filter>>();
    private final List<RankEntity<RouterInterceptor>> _interceptorNodes = new ArrayList<RankEntity<RouterInterceptor>>();

    public synchronized void addFilter(Filter filter, int index) {
        if (filter instanceof PathLimiter) {
            filter = new FilterLimiter(filter, ((PathLimiter)((Object)filter)).pathRule());
        }
        this._filterNodes.add(new RankEntity<Filter>(filter, index));
        this._filterNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public void doFilter(Context x) throws Throwable {
        new FilterChainImpl(this._filterNodes).doFilter(x);
    }

    public synchronized void addInterceptor(RouterInterceptor interceptor, int index) {
        if (interceptor instanceof PathLimiter) {
            interceptor = new RouterInterceptorLimiter(interceptor, ((PathLimiter)((Object)interceptor)).pathRule());
        }
        this._interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
        this._interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public void doIntercept(Context x, @Nullable Handler mainHandler) throws Throwable {
        new RouterInterceptorChainImpl(this._interceptorNodes).doIntercept(x, mainHandler);
    }

    public Object postResult(Context x, @Nullable Object result) throws Throwable {
        for (RankEntity<RouterInterceptor> e : this._interceptorNodes) {
            result = ((RouterInterceptor)e.target).postResult(x, result);
        }
        return result;
    }
}

