/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChain;
import org.noear.solon.core.util.PathRule;

public abstract class RouterRuleInterceptor
implements RouterInterceptor {
    protected final PathRule pathRule = new PathRule();

    protected boolean isMatched(Context ctx) {
        return this.pathRule.isEmpty() || this.pathRule.test(ctx.path());
    }

    public RouterRuleInterceptor include(String ... pathPatterns) {
        this.pathRule.include(pathPatterns);
        return this;
    }

    public RouterRuleInterceptor exclude(String ... pathPatterns) {
        this.pathRule.exclude(pathPatterns);
        return this;
    }

    @Override
    public void doIntercept(Context ctx, Handler mainHandler, RouterInterceptorChain chain) throws Throwable {
        if (this.isMatched(ctx)) {
            this.doRuleIntercept(ctx, mainHandler, chain);
        } else {
            chain.doIntercept(ctx, mainHandler);
        }
    }

    protected abstract void doRuleIntercept(Context var1, Handler var2, RouterInterceptorChain var3) throws Throwable;
}

