/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.PluginEntity;

public class PluginPackage {
    private final File file;
    private final JarClassLoader classLoader;
    private final List<PluginEntity> plugins;

    public PluginPackage(File file, JarClassLoader classLoader, List<PluginEntity> plugins) {
        if (plugins.size() > 0) {
            plugins.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
        }
        this.file = file;
        this.plugins = plugins;
        this.classLoader = classLoader;
    }

    public File getFile() {
        return this.file;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class<?> loadClass(String className) {
        return Utils.loadClass(this.getClassLoader(), className);
    }

    public <T> T newInstance(String className) {
        return Utils.newInstance(this.getClassLoader(), className);
    }

    public URL getResource(String name) {
        return Utils.getResource(this.getClassLoader(), name);
    }

    public String getResourceAsString(String name) throws IOException {
        return Utils.getResourceAsString(this.getClassLoader(), name, Solon.encoding());
    }

    public String getResourceAsString(String name, String charset) throws IOException {
        return Utils.getResourceAsString(this.getClassLoader(), name, charset);
    }

    public PluginPackage start() {
        for (PluginEntity p1 : this.plugins) {
            p1.start();
        }
        return this;
    }

    public PluginPackage prestop() {
        for (PluginEntity p1 : this.plugins) {
            p1.prestop();
        }
        return this;
    }

    public PluginPackage stop() {
        for (PluginEntity p1 : this.plugins) {
            p1.stop();
        }
        return this;
    }
}

