/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.Serializable;
import org.noear.solon.annotation.Note;

public class Result<T>
implements Serializable {
    public static int SUCCEED_CODE = 200;
    public static int FAILURE_CODE = 400;
    private int code;
    private String description;
    private T data;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public Result() {
        this.code = SUCCEED_CODE;
        this.description = "";
    }

    public Result(T data) {
        this.code = SUCCEED_CODE;
        this.description = "";
        this.data = data;
    }

    public Result(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public Result(int code, String description, T data) {
        this.code = code;
        this.description = description;
        this.data = data;
    }

    @Note(value="\u6210\u529f\u7684\u7a7a\u7ed3\u679c")
    public static <T> Result<T> succeed() {
        return new Result<T>(SUCCEED_CODE, "");
    }

    @Note(value="\u6210\u529f\u7684\u7ed3\u679c")
    public static <T> Result<T> succeed(T data) {
        return new Result<T>(data);
    }

    @Note(value="\u6210\u529f\u7684\u7ed3\u679c")
    public static <T> Result<T> succeed(T data, String description) {
        return new Result<T>(SUCCEED_CODE, description, data);
    }

    @Note(value="\u6210\u529f\u7684\u7ed3\u679c")
    public static <T> Result<T> succeed(T data, int code) {
        return new Result<T>(code, "", data);
    }

    @Note(value="\u5931\u8d25\u7684\u7a7a\u7ed3\u679c")
    public static <T> Result<T> failure() {
        return new Result<T>(FAILURE_CODE, "");
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(int code) {
        return Result.failure(code, "");
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(int code, String description) {
        return new Result<T>(code, description);
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(String description) {
        return new Result<T>(FAILURE_CODE, description);
    }
}

