/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Note;
import org.noear.solon.annotation.Remoting;
import org.noear.solon.annotation.ServerEndpoint;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.RunnableEntity;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.VarGather;
import org.noear.solon.ext.BiConsumerEx;

public class AopContext
extends BeanContainer {
    private Set<Class<?>> tryCreateCached = new HashSet();
    private boolean loadDone;
    private Set<RunnableEntity> loadEvents = new LinkedHashSet<RunnableEntity>();

    public AopContext() {
        this.initialize();
    }

    protected void initialize() {
        this.beanBuilderAdd(Configuration.class, (clz, bw, anno) -> {
            this.beanInjectProperties(clz, bw);
            for (Method m : ClassWrap.get(bw.clz()).getMethods()) {
                Bean m_an = m.getAnnotation(Bean.class);
                if (m_an == null) continue;
                m.setAccessible(true);
                MethodWrap mWrap = MethodWrap.get(m);
                this.tryBuildBean(m_an, mWrap, bw);
            }
            this.addBeanShape(clz, bw, 0);
            for (Annotation a1 : clz.getAnnotations()) {
                if (a1 instanceof Import) {
                    this.beanImport((Import)a1);
                    continue;
                }
                this.beanImport(a1.annotationType().getAnnotation(Import.class));
            }
        });
        this.beanBuilderAdd(Component.class, (clz, bw, anno) -> {
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            bw.nameSet(beanName);
            bw.tagSet(anno.tag());
            bw.attrsSet(anno.attrs());
            bw.typedSet(anno.typed());
            this.addBeanShape(clz, bw, anno.index());
            this.beanRegister(bw, beanName, anno.typed());
            this.beanExtract(bw);
            if (bw.singleton()) {
                EventBus.push(bw.raw());
            }
        });
        this.beanBuilderAdd(Remoting.class, (clz, bw, anno) -> {
            bw.remotingSet(true);
            this.beanRegister(bw, "", false);
        });
        this.beanBuilderAdd(Controller.class, (clz, bw, anno) -> new HandlerLoader(bw).load(Solon.global()));
        this.beanBuilderAdd(ServerEndpoint.class, (clz, wrap, anno) -> {
            if (Listener.class.isAssignableFrom(clz)) {
                Listener l = (Listener)wrap.raw();
                Solon.global().router().add(Utils.annoAlias(anno.value(), anno.path()), anno.method(), l);
            }
        });
        this.beanInjectorAdd(Inject.class, (fwT, anno) -> this.beanInject(fwT, anno.value(), anno.autoRefreshed()));
    }

    private void addBeanShape(Class<?> clz, BeanWrap bw, int index) {
        Mapping mapping;
        if (Plugin.class.isAssignableFrom(clz)) {
            Solon.global().plug((Plugin)bw.raw());
            return;
        }
        if (EventListener.class.isAssignableFrom(clz)) {
            this.addEventListener(clz, bw);
            return;
        }
        if (LoadBalance.Factory.class.isAssignableFrom(clz)) {
            Bridge.upstreamFactorySet((LoadBalance.Factory)bw.raw());
        }
        if (Handler.class.isAssignableFrom(clz) && (mapping = clz.getAnnotation(Mapping.class)) != null) {
            Handler handler = (Handler)bw.raw();
            List<MethodType> v0 = MethodTypeUtil.findAndFill(new ArrayList<MethodType>(), t -> bw.annotationGet(t) != null);
            if (v0.size() == 0) {
                v0 = Arrays.asList(mapping.method());
            }
            Solon.global().add(mapping, v0, handler);
        }
        if (Filter.class.isAssignableFrom(clz)) {
            Solon.global().filter(index, (Filter)bw.raw());
        }
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        Class<?>[] ets = GenericUtil.resolveTypeArguments(clz, EventListener.class);
        if (ets != null && ets.length > 0) {
            EventBus.subscribe(ets[0], (EventListener)bw.raw());
        }
    }

    public void beanExtract(BeanWrap bw) {
        if (bw == null) {
            return;
        }
        if (this.beanExtractors.size() == 0) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(bw.clz());
        for (Method m : clzWrap.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                BeanExtractor be = (BeanExtractor)this.beanExtractors.get(a.annotationType());
                if (be == null) continue;
                be.doExtract(bw, m, a);
            }
        }
    }

    public void beanInject(Object obj) {
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        for (Map.Entry<String, FieldWrap> kv : clzWrap.getFieldAllWraps().entrySet()) {
            Annotation[] annS = kv.getValue().annoS;
            if (annS.length <= 0) continue;
            VarHolder varH = kv.getValue().holder(obj);
            this.tryInject(varH, annS);
        }
    }

    public void beanImport(Import anno) {
        if (anno != null) {
            for (Class<?> clz : anno.value()) {
                this.beanMake(clz);
            }
            for (String pkg : anno.scanPackages()) {
                this.beanScan(pkg);
            }
            for (Class<?> src : anno.scanPackageClasses()) {
                this.beanScan(src);
            }
        }
    }

    public void beanScan(Class<?> source) {
        if (source.getPackage() != null) {
            this.beanScan(source.getClassLoader(), source.getPackage().getName());
        }
    }

    public void beanScan(String basePackage) {
        this.beanScan(JarClassLoader.global(), basePackage);
    }

    public void beanScan(ClassLoader classLoader, String basePackage) {
        if (Utils.isEmpty(basePackage)) {
            return;
        }
        if (classLoader == null) {
            return;
        }
        String dir = basePackage.replace('.', '/');
        ScanUtil.scan(classLoader, dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = Utils.loadClass(classLoader, className.replace("/", "."));
            if (clz != null) {
                this.tryCreateBean(clz);
            }
        });
    }

    public BeanWrap beanMake(Class<?> clz) {
        BeanWrap bw = this.wrap(clz, null);
        this.tryCreateBean(bw);
        this.putWrap(clz, bw);
        return bw;
    }

    protected void tryInject(VarHolder varH, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector bi = (BeanInjector)this.beanInjectors.get(a.annotationType());
            if (bi == null) continue;
            bi.doInject(varH, a);
        }
    }

    protected void tryCreateBean(Class<?> clz) {
        this.tryCreateBean0(clz, (c, a) -> {
            BeanWrap bw = this.wrap(clz, null);
            c.doBuild(clz, bw, a);
            this.putWrap(clz, bw);
        });
    }

    protected void tryCreateBean(BeanWrap bw) {
        this.tryCreateBean0(bw.clz(), (c, a) -> c.doBuild(bw.clz(), bw, a));
    }

    protected void tryCreateBean0(Class<?> clz, BiConsumerEx<BeanBuilder, Annotation> consumer) {
        Annotation[] annS = clz.getDeclaredAnnotations();
        if (annS.length > 0) {
            if (this.tryCreateCached.contains(clz)) {
                return;
            }
            this.tryCreateCached.add(clz);
            try {
                for (Annotation a : annS) {
                    BeanBuilder builder = (BeanBuilder)this.beanBuilders.get(a.annotationType());
                    if (builder == null) continue;
                    consumer.accept(builder, a);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void tryBuildBean(Bean anno, MethodWrap mWrap, BeanWrap bw) throws Exception {
        int size2 = mWrap.getParamWraps().length;
        if (size2 == 0) {
            Object raw = mWrap.invoke(bw.raw(), new Object[0]);
            this.tryBuildBean0(mWrap, anno, raw);
        } else {
            VarGather gather = new VarGather(size2, args2 -> {
                try {
                    Object raw = mWrap.invoke(bw.raw(), (Object[])args2);
                    this.tryBuildBean0(mWrap, anno, raw);
                }
                catch (Throwable ex) {
                    ex = Utils.throwableUnwrap(ex);
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            });
            for (ParamWrap p1 : mWrap.getParamWraps()) {
                VarHolder p2 = gather.add(p1.getParameter());
                this.tryParameterInject(p2, p1.getParameter());
            }
        }
    }

    protected void tryParameterInject(VarHolder varH, Parameter p) {
        Annotation[] annoS = p.getDeclaredAnnotations();
        if (annoS.length == 0) {
            this.beanInject(varH, null);
        } else {
            for (Annotation anno : annoS) {
                BeanInjector injector = (BeanInjector)this.beanInjectors.get(anno.annotationType());
                if (injector == null) continue;
                injector.doInject(varH, anno);
                break;
            }
        }
    }

    protected void tryBuildBean0(MethodWrap mWrap, Bean anno, Object raw) {
        if (raw != null) {
            Class<?> beanClz = mWrap.getReturnType();
            Inject beanInj = mWrap.getAnnotation(Inject.class);
            BeanWrap m_bw = null;
            if (raw instanceof BeanWrap) {
                m_bw = (BeanWrap)raw;
            } else {
                if (beanInj != null && !Utils.isEmpty(beanInj.value()) && beanInj.value().startsWith("${")) {
                    Utils.injectProperties(raw, Solon.cfg().getPropByExpr(beanInj.value()));
                }
                EventBus.push(raw);
                m_bw = new BeanWrap(beanClz, raw);
                m_bw.attrsSet(anno.attrs());
            }
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            m_bw.nameSet(beanName);
            m_bw.tagSet(anno.tag());
            m_bw.typedSet(anno.typed());
            this.addBeanShape(m_bw.clz(), m_bw, anno.index());
            this.beanRegister(m_bw, beanName, anno.typed());
            EventBus.push(m_bw);
        }
    }

    @Note(value="\u6dfb\u52a0bean\u52a0\u8f7d\u5b8c\u6210\u4e8b\u4ef6")
    public void beanOnloaded(Runnable fun) {
        this.beanOnloaded(0, fun);
    }

    @Note(value="\u6dfb\u52a0bean\u52a0\u8f7d\u5b8c\u6210\u4e8b\u4ef6")
    public void beanOnloaded(int index, Runnable fun) {
        this.loadEvents.add(new RunnableEntity(fun, index));
        if (this.loadDone) {
            fun.run();
        }
    }

    public void beanLoaded() {
        this.loadDone = true;
        this.loadEvents.stream().sorted(Comparator.comparingInt(m -> m.index)).forEach(m -> m.runnable.run());
    }
}

