/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.wrap.ClassWrap;

public class Props
extends Properties {
    public Props() {
    }

    public Props(Properties defaults) {
        super(defaults);
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String getByExpr(String expr) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        return this.get(name);
    }

    public String getByParse(String expr) {
        int start = expr.indexOf("${");
        if (start < 0) {
            return expr;
        }
        int end = expr.indexOf("}");
        String name = expr.substring(start + 2, end);
        String value = this.get(name);
        return expr.substring(0, start) + value + expr.substring(end + 1);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public boolean getBool(String key, boolean def) {
        return this.getOrDef(key, def, Boolean::parseBoolean);
    }

    public int getInt(String key, int def) {
        return this.getOrDef(key, def, Integer::parseInt);
    }

    public long getLong(String key, long def) {
        return this.getOrDef(key, def, Long::parseLong);
    }

    public Double getDouble(String key, double def) {
        return this.getOrDef(key, def, Double::parseDouble);
    }

    private <T> T getOrDef(String key, T def, Function<String, T> convert) {
        String temp = this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return convert.apply(temp);
    }

    public <T> T getBean(String keyStarts, Class<T> type) {
        return ClassWrap.get(type).newBy(this.getProp(keyStarts));
    }

    public Props getProp(String keyStarts) {
        Props prop = new Props();
        this.doFind(keyStarts, prop::put);
        return prop;
    }

    public Props getPropByExpr(String expr) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        return this.getProp(name);
    }

    public NvMap getXmap(String keyStarts) {
        NvMap map = new NvMap();
        this.doFind(keyStarts, map::put);
        return map;
    }

    private void doFind(String keyStarts, BiConsumer<String, String> setFun) {
        String key2 = keyStarts + ".";
        int idx2 = key2.length();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String keyStr;
            if (k instanceof String && v instanceof String && (keyStr = (String)k).startsWith(key2)) {
                String key = keyStr.substring(idx2);
                setFun.accept(key, (String)v);
                if (key.contains("-")) {
                    String[] ss = key.split("-");
                    StringBuilder sb = new StringBuilder(key.length());
                    sb.append(ss[0]);
                    for (int i = 1; i < ss.length; ++i) {
                        if (ss[i].length() > 1) {
                            sb.append(ss[i].substring(0, 1).toUpperCase()).append(ss[i].substring(1));
                            continue;
                        }
                        sb.append(ss[i].toUpperCase());
                    }
                    setFun.accept(sb.toString(), (String)v);
                }
            }
        }));
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        if (this.defaults != null) {
            this.defaults.forEach(action);
        }
        super.forEach(action);
    }
}

