/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.ResourceScaner;

public final class SolonProps
extends Props {
    private NvMap args;
    private List<PluginEntity> plugs = new ArrayList<PluginEntity>();
    private boolean isDebugMode;
    private boolean isDriftMode;
    private boolean isFilesMode;
    private String extend;
    private String extendFilter;
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public SolonProps() {
        super(System.getProperties());
    }

    public SolonProps load(NvMap args) {
        this.args = args;
        this.loadAdd(Utils.getResource("application.properties"));
        this.loadAdd(Utils.getResource("application.yml"));
        String active = this.get("solon.profiles.active");
        if (Utils.isNotEmpty(active)) {
            this.loadAdd(Utils.getResource("application-" + active + ".properties"));
            this.loadAdd(Utils.getResource("application-" + active + ".yml"));
        }
        this.args.forEach((? super K k, ? super V v) -> {
            if (k.indexOf(".") >= 0) {
                this.setProperty((String)k, (String)v);
                System.setProperty(k, v);
            }
        });
        this.isDebugMode = this.argx().getInt("debug") == 1;
        this.isDriftMode = this.argx().getInt("drift") == 1;
        this.isFilesMode = "file".equals(this.getClass().getProtectionDomain().getCodeSource().getLocation().getProtocol());
        if (this.isDebugMode()) {
            System.setProperty("debug", "1");
        }
        this.extend = (String)this.args.get("extend");
        if (Utils.isEmpty(this.extend)) {
            this.extend = this.get("solon.extend");
        }
        this.extendFilter = (String)this.args.get("extend.filter");
        if (Utils.isEmpty(this.extendFilter)) {
            this.extendFilter = this.get("solon.extend.filter");
        }
        return this;
    }

    public SolonProps loadAdd(URL url) {
        Properties prop;
        if (url != null && (prop = Utils.loadProperties(url)) != null) {
            this.putAll((Map<?, ?>)prop);
            System.getProperties().putAll((Map<?, ?>)prop);
        }
        return this;
    }

    public SolonProps loadAdd(String url) {
        return this.loadAdd(Utils.getResource(url));
    }

    protected void plugsScan() {
        ResourceScaner.scan("solonplugin", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> Utils.getResource(k)).forEach((? super T url) -> this.plugsScanMapDo((URL)url));
        ResourceScaner.scan("META-INF/solon", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> Utils.getResource(k)).forEach((? super T url) -> this.plugsScanMapDo((URL)url));
        if (this.plugs.size() > 0) {
            this.plugs.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
        }
    }

    private void plugsScanMapDo(URL url) {
        try {
            Props p = new Props(Utils.loadProperties(url));
            String temp = p.get("solon.plugin");
            if (!Utils.isEmpty(temp)) {
                PluginEntity ent = new PluginEntity();
                ent.clzName = temp;
                ent.priority = p.getInt("solon.plugin.priority", 0);
                this.plugs.add(ent);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public NvMap argx() {
        return this.args;
    }

    public List<PluginEntity> plugs() {
        return this.plugs;
    }

    public int serverPort() {
        return this.getInt("server.port", 8080);
    }

    public String extend() {
        return this.extend;
    }

    public String extendFilter() {
        return this.extendFilter;
    }

    public String version() {
        return "1.2";
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isFilesMode() {
        return this.isFilesMode;
    }

    public boolean isDriftMode() {
        return this.isDriftMode;
    }
}

