/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.PathAnalyzer;

public class RouteTable<T>
extends ArrayList<Route<T>> {
    public T matchOne(String path, MethodType method) {
        for (Route l : this) {
            if (!l.matches(method, path)) continue;
            return l.target;
        }
        return null;
    }

    public List<T> matchAll(String path, MethodType method) {
        return this.stream().filter(l -> l.matches(method, path)).sorted(Comparator.comparingInt(l -> l.index)).map(l -> l.target).collect(Collectors.toList());
    }

    public static class Route<T> {
        public final int index;
        public final T target;
        private final String _p;
        private final PathAnalyzer _pr;
        private final MethodType _m;

        public Route(String path, MethodType method, int index, T target) {
            this._p = path;
            this._pr = new PathAnalyzer(path);
            this._m = method;
            this.index = index;
            this.target = target;
        }

        public boolean matches(MethodType method2, String path2) {
            if (MethodType.ALL.code == this._m.code) {
                return this.matches0(path2);
            }
            if (MethodType.HTTP.code == this._m.code ? method2.isHttpMethod() : method2.code == this._m.code) {
                return this.matches0(path2);
            }
            return false;
        }

        private boolean matches0(String path2) {
            if ("**".equals(this._p)) {
                return true;
            }
            if (this._p.equals(path2)) {
                return true;
            }
            return this._pr.matches(path2);
        }
    }
}

