/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.message;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Function;

public class Message {
    private final int flag;
    private final String key;
    private final String resourceDescriptor;
    private final byte[] content;
    private Charset charset = StandardCharsets.UTF_8;
    private boolean _handled;

    public int flag() {
        return this.flag;
    }

    public String key() {
        return this.key;
    }

    public String resourceDescriptor() {
        return this.resourceDescriptor;
    }

    public byte[] content() {
        return this.content;
    }

    public <T> T map(Function<Message, T> mapper) {
        return mapper.apply(this);
    }

    private Message(int flag, String key, String resourceDescriptor, byte[] bytes) {
        this.flag = flag;
        this.key = key == null ? "" : key;
        this.resourceDescriptor = resourceDescriptor == null ? "" : resourceDescriptor;
        this.content = bytes;
    }

    public String toString() {
        if (this.content == null) {
            return null;
        }
        return new String(this.content, this.charset);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public boolean getHandled() {
        return this._handled;
    }

    public static Message wrap(byte[] bytes) {
        return Message.wrap(0, "", "", bytes);
    }

    public static Message wrap(String resourceDescriptor, byte[] bytes) {
        return Message.wrap(0, UUID.randomUUID().toString(), resourceDescriptor, bytes);
    }

    public static Message wrap(String key, String resourceDescriptor, byte[] bytes) {
        return Message.wrap(0, key, resourceDescriptor, bytes);
    }

    public static Message wrap(int flag, String key, String resourceDescriptor, byte[] bytes) {
        return new Message(flag, key, resourceDescriptor, bytes);
    }
}

