/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.util.IndexBuilder;
import org.noear.solon.core.wrap.ClassWrap;

public class BeanWrap {
    private Class<?> clz;
    private Method clzInit;
    private boolean clzInitDelay;
    private int clzInitIndex;
    private Object raw;
    private boolean singleton;
    private boolean remoting;
    private String name;
    private String tag;
    @Deprecated
    private String[] attrs;
    @Deprecated
    private Map<String, String> attrMap;
    private boolean typed;
    private Proxy proxy;
    private final Annotation[] annotations;
    private final AopContext context;

    public BeanWrap(AopContext context, Class<?> clz) {
        this(context, clz, null);
    }

    public BeanWrap(AopContext context, Class<?> clz, Object raw) {
        this(context, clz, raw, null);
    }

    public BeanWrap(AopContext context, Class<?> clz, Object raw, String name) {
        this(context, clz, raw, name, false);
    }

    public BeanWrap(AopContext context, Class<?> clz, Object raw, String name, boolean typed) {
        this.context = context;
        this.clz = clz;
        this.name = name;
        this.typed = typed;
        Singleton ano = clz.getAnnotation(Singleton.class);
        this.singleton = ano == null || ano.value();
        this.annotations = clz.getAnnotations();
        this.tryBuildInit();
        this.raw = raw == null ? this._new() : raw;
    }

    public AopContext context() {
        return this.context;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public void proxySet(Proxy proxy) {
        this.proxy = proxy;
        if (this.raw != null) {
            this.raw = proxy.getProxy(this.context(), this.raw);
        }
    }

    public boolean singleton() {
        return this.singleton;
    }

    public void singletonSet(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean remoting() {
        return this.remoting;
    }

    public void remotingSet(boolean remoting) {
        this.remoting = remoting;
    }

    public Class<?> clz() {
        return this.clz;
    }

    public <T> T raw() {
        return (T)this.raw;
    }

    protected void rawSet(Object raw) {
        this.raw = raw;
    }

    public String name() {
        return this.name;
    }

    protected void nameSet(String name) {
        this.name = name;
    }

    public String tag() {
        return this.tag;
    }

    protected void tagSet(String tag) {
        this.tag = tag;
    }

    @Deprecated
    public String[] attrs() {
        return this.attrs;
    }

    @Deprecated
    protected void attrsSet(String[] attrs) {
        this.attrs = attrs;
    }

    @Deprecated
    public String attrGet(String name) {
        if (this.attrs == null) {
            return null;
        }
        if (this.attrMap == null) {
            this.attrMap = new HashMap<String, String>();
            for (String kv : this.attrs) {
                String[] ss = kv.split("=");
                if (ss.length != 2) continue;
                this.attrMap.put(ss[0], ss[1]);
            }
        }
        return this.attrMap.get(name);
    }

    public boolean typed() {
        return this.typed;
    }

    protected void typedSet(boolean typed) {
        this.typed = typed;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T annotationGet(Class<T> annClz) {
        return this.clz.getAnnotation(annClz);
    }

    public <T> T get() {
        if (this.singleton) {
            return (T)this.raw;
        }
        return (T)this._new();
    }

    protected void init(Object bean) {
        this.context.beanInject(bean);
        if (this.clzInit != null) {
            if (this.clzInitDelay) {
                if (this.clzInitIndex == 0) {
                    this.clzInitIndex = new IndexBuilder().buildIndex(this.clz);
                }
                this.context.beanOnloaded(this.clzInitIndex, ctx -> this.initInvokeDo(bean));
            } else {
                this.initInvokeDo(bean);
            }
        }
    }

    protected void initInvokeDo(Object bean) {
        try {
            this.clzInit.invoke(bean, new Object[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object _new() {
        if (this.clz.isInterface()) {
            return this.raw;
        }
        try {
            Object bean = Utils.newInstance(this.clz);
            this.init(bean);
            if (this.proxy != null) {
                bean = this.proxy.getProxy(this.context(), bean);
            }
            return bean;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Instantiation failure: " + this.clz.getTypeName(), ex);
        }
    }

    protected void tryBuildInit() {
        if (this.clzInit != null) {
            return;
        }
        if (this.clz.isInterface()) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(this.clz);
        for (Method m : clzWrap.getMethods()) {
            Init initAnno = m.getAnnotation(Init.class);
            if (initAnno == null) continue;
            if (m.getParameters().length != 0) break;
            this.clzInit = m;
            this.clzInit.setAccessible(true);
            this.clzInitDelay = initAnno.delay();
            this.clzInitIndex = initAnno.index();
            break;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanWrap)) {
            return false;
        }
        BeanWrap beanWrap = (BeanWrap)o;
        return this.clz.equals(beanWrap.clz);
    }

    public int hashCode() {
        return Objects.hash(this.clz);
    }

    @FunctionalInterface
    public static interface Proxy {
        public Object getProxy(AopContext var1, Object var2);
    }
}

