/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.noear.solon.SolonApp;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.PrintUtil;

public class Solon {
    private static int stopDelay = 10;
    private static SolonApp app;
    private static String encoding;
    private static final AopContext ac;

    public static AopContext context() {
        return ac;
    }

    @Deprecated
    public static SolonApp global() {
        return app;
    }

    public static SolonApp app() {
        return app;
    }

    public static SolonProps cfg() {
        return Solon.app().cfg();
    }

    public static String encoding() {
        return encoding;
    }

    public static void encodingSet(String charset) {
        if (app == null && Utils.isNotEmpty(charset)) {
            encoding = charset;
        }
    }

    public static SolonApp start(Class<?> source, String[] args) {
        return Solon.start(source, args, null);
    }

    public static SolonApp start(Class<?> source, String[] args, ConsumerEx<SolonApp> initialize) {
        NvMap argx = NvMap.from(args);
        return Solon.start(source, argx, initialize);
    }

    public static SolonApp start(Class<?> source, NvMap argx, ConsumerEx<SolonApp> initialize) {
        if (app != null) {
            return app;
        }
        if (Utils.isNotEmpty(encoding)) {
            System.setProperty("file.encoding", encoding);
        }
        System.getProperties().putIfAbsent("java.awt.headless", "true");
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        String pid = rb.getName().split("@")[0];
        System.setProperty("PID", pid);
        JarClassLoader.bindingThread();
        PrintUtil.info("App", "Start loading");
        try {
            app = new SolonApp(source, argx);
            app.initAwait();
            app.init();
            if (initialize != null) {
                initialize.accept(app);
            }
            app.run();
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            EventBus.push(ex);
            if (!app.enableErrorAutoprint()) {
                ex.printStackTrace();
            }
            Solon.stop0(true, 0);
            return null;
        }
        stopDelay = Solon.cfg().getInt("solon.stop.delay", 10);
        if (app.enableSafeStop()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, stopDelay)));
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, 0)));
        }
        PrintUtil.info("App", "End loading elapsed=" + app.elapsedTimes() + "ms pid=" + pid);
        return app;
    }

    public static void stopDelaySet(int delay) {
        stopDelay = delay;
    }

    public static void stop() {
        Solon.stop(stopDelay);
    }

    public static void stop(int delay) {
        new Thread(() -> Solon.stop0(true, delay)).start();
    }

    private static void stop0(boolean exit, int delay) {
        if (Solon.app() == null) {
            return;
        }
        if (delay > 0) {
            String hint = "(1.prestop 2.delay 3.stop)";
            PrintUtil.info("App", "Security to stop: begin..." + hint);
            Solon.cfg().plugs().forEach(p -> p.prestop());
            PrintUtil.info("App", "Security to stop: 1 completed " + hint);
            int delay1 = (int)((double)delay * 0.2);
            int delay2 = delay - delay1;
            if (delay1 > 0) {
                Solon.sleep0(delay1);
            }
            Solon.app().stopped = true;
            if (delay2 > 0) {
                Solon.sleep0(delay2);
            }
            PrintUtil.info("App", "Security to stop: 2 completed " + hint);
            Solon.cfg().plugs().forEach(p -> p.stop());
            PrintUtil.info("App", "Security to stop: 3 completed " + hint);
        } else {
            Solon.cfg().plugs().forEach(p -> p.prestop());
            Solon.app().stopped = true;
            Solon.cfg().plugs().forEach(p -> p.stop());
        }
        if (exit) {
            System.exit(1);
        }
    }

    private static void sleep0(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        encoding = "utf-8";
        ac = new AopContext();
    }
}

