/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XAfter;
import org.noear.solon.annotation.XBefore;
import org.noear.solon.annotation.XMapping;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.XAction;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerAide;
import org.noear.solon.core.XHandlerSlots;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XRender;
import org.noear.solon.ext.ConsumerEx;

public class XHandlerLoader
extends XHandlerAide {
    protected BeanWrap bw;
    protected XRender bRender;
    protected XMapping bMapping;
    protected String bPath;
    protected boolean bRemoting;
    protected boolean allowMapping;

    public XHandlerLoader(BeanWrap wrap) {
        this.bMapping = wrap.clz().getAnnotation(XMapping.class);
        if (this.bMapping == null) {
            this.initDo(wrap, null, wrap.remoting(), null, true);
        } else {
            this.initDo(wrap, this.bMapping.value(), wrap.remoting(), null, true);
        }
    }

    public XHandlerLoader(BeanWrap wrap, String mapping) {
        this.initDo(wrap, mapping, wrap.remoting(), null, true);
    }

    public XHandlerLoader(BeanWrap wrap, String mapping, boolean remoting) {
        this.initDo(wrap, mapping, remoting, null, true);
    }

    public XHandlerLoader(BeanWrap wrap, String mapping, boolean remoting, XRender render, boolean allowMapping) {
        this.initDo(wrap, mapping, remoting, render, allowMapping);
    }

    private void initDo(BeanWrap wrap, String mapping, boolean remoting, XRender render, boolean allowMapping) {
        this.bw = wrap;
        this.bRender = render;
        this.allowMapping = allowMapping;
        if (mapping != null) {
            this.bPath = mapping;
        }
        this.bRemoting = remoting;
    }

    public String mapping() {
        return this.bPath;
    }

    public void load(XHandlerSlots slots) {
        this.load(this.bRemoting, slots);
    }

    public void load(boolean all, XHandlerSlots slots) {
        if (XHandler.class.isAssignableFrom(this.bw.clz())) {
            this.loadHandlerDo(slots);
        } else {
            this.loadActionDo(slots, all || this.bRemoting);
        }
    }

    protected void loadHandlerDo(XHandlerSlots slots) {
        if (this.bMapping == null) {
            throw new RuntimeException(this.bw.clz().getName() + " No @XMapping!");
        }
        XHandler handler = (XHandler)this.bw.raw();
        slots.add(this.bMapping, handler);
    }

    protected void loadActionDo(XHandlerSlots slots, boolean all) {
        if (this.bPath == null) {
            this.bPath = "";
        }
        this.loadControllerAide();
        int m_index = 0;
        for (Method method : this.bw.clz().getDeclaredMethods()) {
            XMethod[] m_method;
            String m_path;
            XMapping m_map = method.getAnnotation(XMapping.class);
            m_index = 0;
            if (m_map != null) {
                m_path = m_map.value();
                m_method = m_map.method();
                m_index = m_map.index();
            } else {
                m_path = method.getName();
                m_method = this.bMapping == null ? new XMethod[]{XMethod.HTTP} : this.bMapping.method();
            }
            if (m_map == null && !all) continue;
            String newPath = XUtil.mergePath(this.bPath, m_path);
            XAction action = this.createAction(this.bw, method, m_map, newPath, this.bRemoting);
            this.loadActionAide(method, action);
            for (XMethod m1 : m_method) {
                if (m_map == null) {
                    slots.add(newPath, m1, action);
                    continue;
                }
                if (m_map.after() || m_map.before()) {
                    if (m_map.after()) {
                        slots.after(newPath, m1, m_index, action);
                        continue;
                    }
                    slots.before(newPath, m1, m_index, action);
                    continue;
                }
                slots.add(newPath, m1, action);
            }
        }
    }

    protected void loadControllerAide() {
        for (Annotation anno : this.bw.clz().getAnnotations()) {
            if (anno instanceof XBefore) {
                XHandlerLoader.addDo(((XBefore)anno).value(), b -> this.before((XHandler)Aop.get(b)));
                continue;
            }
            if (anno instanceof XAfter) {
                XHandlerLoader.addDo(((XAfter)anno).value(), f -> this.after((XHandler)Aop.get(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof XBefore) {
                    XHandlerLoader.addDo(((XBefore)anno2).value(), b -> this.before((XHandler)Aop.get(b)));
                    continue;
                }
                if (!(anno2 instanceof XAfter)) continue;
                XHandlerLoader.addDo(((XAfter)anno2).value(), f -> this.after((XHandler)Aop.get(f)));
            }
        }
    }

    protected void loadActionAide(Method method, XAction action) {
        for (Annotation anno : method.getAnnotations()) {
            if (anno instanceof XBefore) {
                XHandlerLoader.addDo(((XBefore)anno).value(), b -> action.before((XHandler)Aop.get(b)));
                continue;
            }
            if (anno instanceof XAfter) {
                XHandlerLoader.addDo(((XAfter)anno).value(), f -> action.after((XHandler)Aop.get(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof XBefore) {
                    XHandlerLoader.addDo(((XBefore)anno2).value(), b -> action.before((XHandler)Aop.get(b)));
                    continue;
                }
                if (!(anno2 instanceof XAfter)) continue;
                XHandlerLoader.addDo(((XAfter)anno2).value(), f -> action.after((XHandler)Aop.get(f)));
            }
        }
    }

    protected XAction createAction(BeanWrap bw, Method method, XMapping mp, String path, boolean remoting) {
        if (this.allowMapping) {
            return new XAction(bw, this, method, mp, path, remoting, this.bRender);
        }
        return new XAction(bw, this, method, null, path, remoting, this.bRender);
    }

    private static <T> void addDo(T[] ary, ConsumerEx<T> fun) {
        if (ary != null) {
            for (T t : ary) {
                try {
                    fun.accept(t);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

