/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.HashSet;
import java.util.Set;
import org.noear.solon.XApp;
import org.noear.solon.core.XActionExecutor;
import org.noear.solon.core.XActionExecutorDefault;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XRender;
import org.noear.solon.core.XRenderManager;
import org.noear.solon.core.XSessionState;
import org.noear.solon.core.XUpstreamFactory;

public class XBridge {
    private static XSessionState _sessionState = new XSessionStateDefault();
    private static boolean _sessionStateUpdated;
    private static XUpstreamFactory _upstreamFactory;
    private static XActionExecutor _actionExecutorDef;
    private static Set<XActionExecutor> _actionExecutors;

    public static void sessionStateSet(XSessionState ss) {
        if (ss != null) {
            _sessionState = ss;
            if (!_sessionStateUpdated) {
                _sessionStateUpdated = true;
                XApp.global().before("**", XMethod.HTTP, c -> _sessionState.sessionRefresh());
            }
        }
    }

    public static XSessionState sessionState() {
        return _sessionState;
    }

    public static XUpstreamFactory upstreamFactory() {
        return _upstreamFactory;
    }

    public static void upstreamFactorySet(XUpstreamFactory uf) {
        _upstreamFactory = uf;
    }

    public static XActionExecutor actionExecutorDef() {
        return _actionExecutorDef;
    }

    public static void actionExecutorDefSet(XActionExecutor ae) {
        _actionExecutorDef = ae;
    }

    public static Set<XActionExecutor> actionExecutors() {
        return _actionExecutors;
    }

    public static void actionExecutorAdd(XActionExecutor executor) {
        _actionExecutors.add(executor);
    }

    public static void renderRegister(XRender render) {
        XRenderManager.register(render);
    }

    public static void renderMapping(String suffix, XRender render) {
        XRenderManager.mapping(suffix, render);
    }

    public static void renderMapping(String suffix, String className) {
        XRenderManager.mapping(suffix, className);
    }

    static {
        _upstreamFactory = service -> {
            throw new RuntimeException("Uninitialized upstreamFactory");
        };
        _actionExecutorDef = new XActionExecutorDefault();
        _actionExecutors = new HashSet<XActionExecutor>();
    }

    static class XSessionStateDefault
    implements XSessionState {
        XSessionStateDefault() {
        }

        @Override
        public String sessionId() {
            return null;
        }

        @Override
        public Object sessionGet(String key) {
            return null;
        }

        @Override
        public void sessionSet(String key, Object val) {
        }
    }
}

