/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XParam;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;

class XActionUtil {
    XActionUtil() {
    }

    protected static Object params2Entity(XContext ctx, Class<?> clz) throws Exception {
        Field[] fields = clz.getDeclaredFields();
        XMap map = ctx.paramMap();
        Object obj = clz.newInstance();
        for (Field f : fields) {
            String key = f.getName();
            if (!map.containsKey(key)) continue;
            Object val = XActionUtil.change(f, f.getType(), key, (String)map.get(key), ctx);
            f.set(obj, val);
        }
        return obj;
    }

    protected static Object exeMethod(Object obj, Method method, XContext ctx) throws Exception {
        try {
            Parameter[] pSet = method.getParameters();
            ArrayList<Object> args = new ArrayList<Object>();
            for (Parameter p : pSet) {
                Class<?> pt = p.getType();
                if (XContext.class.equals(pt)) {
                    args.add(ctx);
                    continue;
                }
                String pn = p.getName();
                String pv = ctx.param(pn);
                if (pv == null) {
                    if (XFile.class == pt) {
                        XFile file = ctx.file(pn);
                        args.add(file);
                        continue;
                    }
                    XParam xd = p.getAnnotation(XParam.class);
                    if (xd != null || pt.getAnnotation(XParam.class) != null) {
                        if (xd != null && !XUtil.isEmpty(xd.value())) {
                            args.add(null);
                            continue;
                        }
                        args.add(XActionUtil.params2Entity(ctx, pt));
                        continue;
                    }
                    args.add(null);
                    continue;
                }
                args.add(XActionUtil.change(p, pt, pn, pv, ctx));
            }
            if (args.size() == 0) {
                return method.invoke(obj, new Object[0]);
            }
            return method.invoke(obj, args.toArray());
        }
        catch (InvocationTargetException ex) {
            throw (Exception)ex.getCause();
        }
    }

    protected static Object change(AnnotatedElement p, Class<?> type, String key, String val, XContext ctx) throws Exception {
        XParam xd;
        if (String.class == type) {
            return val;
        }
        if (val.length() == 0) {
            return null;
        }
        if (Integer.class == type || type == Integer.TYPE) {
            return Integer.parseInt(val);
        }
        if (Long.class == type || type == Long.TYPE) {
            return Long.parseLong(val);
        }
        if (Double.class == type || type == Double.TYPE) {
            return Double.parseDouble(val);
        }
        if (Float.class == type || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (Boolean.class == type || type == Boolean.TYPE) {
            return Boolean.parseBoolean(val);
        }
        if (Date.class == type && (xd = p.getAnnotation(XParam.class)) != null && !XUtil.isEmpty(xd.value())) {
            SimpleDateFormat fm = new SimpleDateFormat(xd.value());
            return fm.parse(val);
        }
        if (String[].class == type) {
            if (ctx == null) {
                return null;
            }
            return ctx.paramValues(key);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7c7b\u578b:" + type.getName());
    }
}

