/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.LinkedHashSet;
import java.util.Set;
import org.noear.solon.XProperties;
import org.noear.solon.XRouter;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XRender;

public class XApp
implements XHandler {
    private static XApp _global;
    private Set<Runnable> _stopEvent = new LinkedHashSet<Runnable>();
    private XRender _render = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };
    private final XRouter<XHandler> _router = new XRouter();
    private final int _port;
    private final XProperties _prop;
    private static final ThreadLocal<XContext> _threadLocal;

    public static XApp global() {
        return _global;
    }

    public static XApp start(Class<?> source, String[] args) {
        if (_global != null) {
            return _global;
        }
        long time_start = System.currentTimeMillis();
        System.out.println("solon.boot:: start begin");
        _global = new XApp(args);
        for (String p : _global.prop().plugs()) {
            XPlugin p1 = (XPlugin)XUtil.newClass(p);
            if (p1 == null) continue;
            _global.plug(p1);
        }
        if (source != null) {
            Aop.beanLoad(source);
        }
        long time_end = System.currentTimeMillis();
        System.out.println("solon.boot:: start end @" + (time_end - time_start) + "ms");
        return _global;
    }

    public static void stop() {
        if (_global == null) {
            return;
        }
        XApp._global._stopEvent.forEach(f -> f.run());
    }

    protected XApp(String[] args) {
        this._prop = new XProperties(args);
        this._port = this._prop.serverPort();
    }

    public void onStop(Runnable event) {
        this._stopEvent.add(event);
    }

    public int port() {
        return this._port;
    }

    public XProperties prop() {
        return this._prop;
    }

    public XRender render() {
        return this._render;
    }

    public void render(Object obj, XContext ctx) throws Exception {
        this.render().render(obj, ctx);
    }

    public void renderSet(XRender render) {
        this._render = render;
    }

    public void plug(XPlugin plugin) {
        plugin.start(this);
    }

    public void before(String expr, String method, XHandler handler) {
        this._router.add(expr, 0, method, handler);
    }

    public void after(String expr, String method, XHandler handler) {
        this._router.add(expr, 2, method, handler);
    }

    public void add(String expr, String method, XHandler handler) {
        this._router.add(expr, 1, method, handler);
    }

    public void all(String path, XHandler handler) {
        this.add(path, "", handler);
    }

    public void get(String path, XHandler handler) {
        this.add(path, "GET", handler);
    }

    public void post(String path, XHandler handler) {
        this.add(path, "POST", handler);
    }

    public void put(String path, XHandler handler) {
        this.add(path, "PUT", handler);
    }

    public void delete(String path, XHandler handler) {
        this.add(path, "DELETE", handler);
    }

    public static XContext currentContext() {
        return _threadLocal.get();
    }

    @Override
    public void handle(XContext context) throws Exception {
        try {
            _threadLocal.set(context);
            this.do_handle(context);
        }
        finally {
            _threadLocal.remove();
        }
    }

    private void do_handle(XContext context) throws Exception {
        boolean _handled = false;
        this.do_try_handle(context, 0);
        if (!context.getHandled()) {
            _handled = this.do_try_handle(context, 1);
        }
        this.do_try_handle(context, 2);
        if (_handled) {
            if (context.status() < 1) {
                context.status(200);
            }
            context.setHandled(true);
        }
        if (context.status() < 1) {
            context.status(404);
        }
    }

    private boolean do_try_handle(XContext context, int endpoint) throws Exception {
        XHandler handler = this._router.matched(context, endpoint);
        if (handler != null) {
            handler.handle(context);
            return true;
        }
        return false;
    }

    static {
        _threadLocal = new ThreadLocal();
    }
}

