/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.web.staticfiles.StaticLocation;
import org.noear.solon.web.staticfiles.StaticRepository;

public class StaticMappings {
    static final Map<StaticRepository, StaticLocation> locationMap = new ConcurrentHashMap<StaticRepository, StaticLocation>();

    public static int count() {
        return locationMap.size();
    }

    public static void add(String pathPrefix, StaticRepository repository) {
        StaticMappings.addDo(pathPrefix, repository, false);
    }

    protected static void addDo(String pathPrefix, StaticRepository repository, boolean repositoryIncPrefix) {
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        locationMap.putIfAbsent(repository, new StaticLocation(pathPrefix, repository, repositoryIncPrefix));
    }

    public static void remove(StaticRepository repository) {
        locationMap.remove(repository);
    }

    public static URL find(String path) throws Exception {
        URL rst = null;
        for (StaticLocation m : locationMap.values()) {
            if (!path.startsWith(m.pathPrefix)) continue;
            if (m.repositoryIncPrefix) {
                rst = m.repository.find(path.substring(1));
            } else if (m.pathPrefixAsFile) {
                int idx = m.pathPrefix.lastIndexOf("/");
                rst = m.repository.find(m.pathPrefix.substring(idx + 1));
            } else {
                rst = m.repository.find(path.substring(m.pathPrefix.length()));
            }
            if (rst == null) continue;
            return rst;
        }
        return rst;
    }
}

