/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sse;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.web.sse.AsyncListenerImpl;
import org.noear.solon.web.sse.SseEmitter;
import org.noear.solon.web.sse.SseEvent;

public class SseEmitterHandler {
    private final SseEmitter emitter;
    private final Context ctx;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public SseEmitterHandler(SseEmitter emitter) {
        this.ctx = Context.current();
        this.emitter = emitter;
    }

    public void start() throws Throwable {
        this.ctx.contentType("text/event-stream;charset=utf-8");
        this.ctx.asyncStart(this.emitter.timeout, (ContextAsyncListener)new AsyncListenerImpl(this));
        this.emitter.initialize(this);
    }

    public synchronized void send(SseEvent event) throws IOException {
        if (event == null) {
            throw new IllegalArgumentException("SSE event cannot be null");
        }
        if (this.stopped.get()) {
            throw new IllegalStateException("SSE emitter was stopped");
        }
        try {
            this.ctx.output(event.build());
            this.ctx.flush();
        }
        catch (IOException e) {
            this.stopOnError(e);
            throw e;
        }
    }

    public void complete() throws IOException {
        this.stop();
    }

    protected void stopOnError(Throwable e) throws IOException {
        if (this.emitter.onError != null) {
            this.emitter.onError.accept(e);
        }
        this.stop();
    }

    protected void stopOnTimeout() throws IOException {
        if (this.emitter.onTimeout != null) {
            this.emitter.onTimeout.run();
        }
        this.stop();
    }

    protected synchronized void stop() throws IOException {
        if (!this.stopped.get()) {
            this.stopped.set(true);
            if (this.emitter.onCompletion != null) {
                this.emitter.onCompletion.run();
            }
            this.ctx.asyncComplete();
        }
    }
}

