/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.web.FormUrlencodedUtils;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IgnoreCaseMap;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.web.servlet.AsyncListenerWrap;
import org.noear.solon.web.servlet.MultipartUtil;
import org.noear.solon.web.servlet.SolonServletSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonServletContext
extends WebContextBase {
    static final Logger log = LoggerFactory.getLogger(SolonServletContext.class);
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private NvMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private NvMap _cookieMap;
    private NvMap _headerMap;
    private Map<String, List<String>> _headersMap;
    AsyncContext asyncContext;
    private boolean _headers_sent = false;

    protected boolean innerIsAsync() {
        return this.asyncContext != null;
    }

    public SolonServletContext(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
        this._filesMap = new HashMap();
        if (this.sessionState().replaceable()) {
            this.sessionState = new SolonServletSessionState(request);
        }
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this, this._filesMap);
        }
    }

    public Object pull(Class<?> clz) {
        Object tmp = super.pull(clz);
        if (tmp == null && clz.isInstance(this._request.getSession())) {
            return this._request.getSession();
        }
        return tmp;
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.getRemoteAddr();
    }

    public int remotePort() {
        return this._request.getRemotePort();
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getRequestURL().toString();
        }
        return this._url;
    }

    public long contentLength() {
        return this._request.getContentLengthLong();
    }

    public String contentType() {
        return this._request.getContentType();
    }

    public String queryString() {
        return this._request.getQueryString();
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw MultipartUtil.status4xx((Context)this, e);
        }
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public NvMap paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        this.paramsMapInit();
        return this._paramsMap;
    }

    private Map<String, List<String>> paramsMapInit() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            this._paramMap = new NvMap();
            try {
                FormUrlencodedUtils.pretreatment((Context)this);
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry kv : this._request.getParameterMap().entrySet()) {
                    String name = ServerProps.urlDecode((String)((String)kv.getKey()));
                    this._paramsMap.put(name, Utils.asList((Object[])((Object[])kv.getValue())));
                    this._paramMap.put(name, (Object)((String[])kv.getValue())[0]);
                }
            }
            catch (Exception e) {
                throw MultipartUtil.status4xx((Context)this, e);
            }
        }
        return this._paramsMap;
    }

    public Map<String, List<UploadedFile>> filesMap() throws IOException {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
            return this._filesMap;
        }
        return Collections.emptyMap();
    }

    public NvMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new NvMap();
            Cookie[] _cookies = this._request.getCookies();
            if (_cookies != null) {
                for (Cookie c : _cookies) {
                    this._cookieMap.put(c.getName(), (Object)c.getValue());
                }
            }
        }
        return this._cookieMap;
    }

    public NvMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new NvMap();
            Enumeration headers = this._request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String key = (String)headers.nextElement();
                String value = this._request.getHeader(key);
                this._headerMap.put(key, (Object)value);
            }
        }
        return this._headerMap;
    }

    public Map<String, List<String>> headersMap() {
        if (this._headersMap == null) {
            this._headersMap = new IgnoreCaseMap();
            Enumeration headers = this._request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String key = (String)headers.nextElement();
                this._headersMap.put(key, Collections.list(this._request.getHeaders(key)));
            }
        }
        return this._headersMap;
    }

    public Object response() {
        return this._response;
    }

    public void charset(String charset) {
        this._response.setCharacterEncoding(charset);
        this.charset = Charset.forName(charset);
    }

    protected void contentTypeDoSet(String contentType) {
        this._response.setContentType(contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders();
        return this._response.getOutputStream();
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.getHeader(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> headerNamesOfResponse() {
        return this._response.getHeaderNames();
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        Cookie c = new Cookie(key, val);
        if (Utils.isNotEmpty((String)path)) {
            c.setPath(path);
        }
        if (maxAge >= 0) {
            c.setMaxAge(maxAge);
        }
        if (Utils.isNotEmpty((String)domain)) {
            c.setDomain(domain);
        }
        this._response.addCookie(c);
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._response.getStatus();
    }

    protected void statusDoSet(int status) {
        this._response.setStatus(status);
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener) {
        if (this.asyncContext == null) {
            this.asyncContext = this._request.startAsync();
            if (listener != null) {
                this.asyncContext.addListener((AsyncListener)new AsyncListenerWrap((Context)this, listener));
            }
            if (timeout != 0L) {
                this.asyncContext.setTimeout(timeout);
            }
        }
    }

    public void asyncComplete() {
        if (this.asyncContext != null) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
            }
            finally {
                this.asyncContext.complete();
            }
        }
    }

    public void flush() throws IOException {
        this.outputStream().flush();
    }

    public void close() throws IOException {
        this.outputStream().close();
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders();
        } else {
            this._response.setStatus(404);
        }
    }

    private void sendHeaders() throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
        }
    }
}

