/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.reactive.integration;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionReactiveSubscriber
implements Subscriber {
    static final Logger log = LoggerFactory.getLogger(ActionReactiveSubscriber.class);
    private Context ctx;
    private Action action;
    private boolean isFlux;
    private List<Object> list;

    public ActionReactiveSubscriber(Context ctx, Action action, boolean isFlux) {
        this.ctx = ctx;
        this.action = action;
        this.isFlux = isFlux;
        this.list = new ArrayList<Object>();
    }

    public void onSubscribe(Subscription subscription) {
        this.ctx.asyncStart(-1L, null, () -> subscription.request(Long.MAX_VALUE));
    }

    public void onNext(Object o) {
        this.list.add(o);
    }

    public void onError(Throwable e) {
        try {
            this.action.render((Object)e, this.ctx, false);
        }
        catch (Throwable e2) {
            this.ctx.status(500);
            log.warn(e.getMessage(), e);
        }
        finally {
            this.onComplete();
        }
    }

    public void onComplete() {
        if (this.ctx.asyncSupported()) {
            try {
                if (this.isFlux) {
                    this.action.render(this.list, this.ctx, false);
                } else if (this.list.size() > 0) {
                    this.action.render(this.list.get(0), this.ctx, false);
                }
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
            finally {
                this.ctx.asyncComplete();
            }
        }
    }
}

