/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.velocity;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.directive.Directive;
import org.noear.solon.Solon;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.ViewConfig;

public class VelocityRender
implements Render {
    private static VelocityRender _global;
    private Map<String, Object> sharedVariables = new HashMap<String, Object>();
    private RuntimeInstance provider;
    private RuntimeInstance providerOfDebug;

    public static VelocityRender global() {
        if (_global == null) {
            _global = new VelocityRender();
        }
        return _global;
    }

    public RuntimeInstance getProvider() {
        return this.provider;
    }

    public RuntimeInstance getProviderOfDebug() {
        return this.providerOfDebug;
    }

    public VelocityRender() {
        this.forDebug();
        this.forRelease();
        this.engineInit(this.provider);
        this.engineInit(this.providerOfDebug);
        EventBus.push((Object)this.providerOfDebug);
        EventBus.push((Object)this.provider);
        Solon.app().shared().forEach((k, v) -> this.putVariable((String)k, v));
        Solon.app().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    private void engineInit(RuntimeInstance ve) {
        if (ve == null) {
            return;
        }
        ve.setProperty("UTF-8", (Object)Solon.encoding());
        ve.setProperty("resource.default_encoding", (Object)Solon.encoding());
        Solon.cfg().forEach((k, v) -> {
            String key = k.toString();
            if (key.startsWith("velocity")) {
                ve.setProperty(key, v);
            }
        });
        ve.init();
    }

    private void forDebug() {
        String dir_str;
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (this.providerOfDebug != null) {
            return;
        }
        URL rooturi = ResourceUtil.getResource((String)"/");
        if (rooturi == null) {
            return;
        }
        this.providerOfDebug = new RuntimeInstance();
        String rootdir = rooturi.toString().replace("target/classes/", "");
        File dir = null;
        if (rootdir.startsWith("file:") && !(dir = new File(URI.create(dir_str = rootdir + "src/main/resources" + ViewConfig.getViewPrefix()))).exists()) {
            dir_str = rootdir + "src/main/webapp" + ViewConfig.getViewPrefix();
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                this.providerOfDebug.setProperty("resource.loader.file.path", (Object)(dir.getAbsolutePath() + File.separatorChar));
            } else {
                this.forRelease();
            }
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        this.provider = new RuntimeInstance();
        URL resource = ResourceUtil.getResource((String)ViewConfig.getViewPrefix());
        if (resource == null) {
            return;
        }
        String root_path = resource.getPath();
        this.provider.setProperty("resource.loader.file.cache", (Object)true);
        this.provider.setProperty("resource.loader.file.path", (Object)root_path);
    }

    public <T extends Directive> void putDirective(T obj) {
        this.provider.addDirective(obj);
        if (this.providerOfDebug != null) {
            this.providerOfDebug.addDirective(obj);
        }
    }

    public void putVariable(String key, Object obj) {
        this.sharedVariables.put(key, obj);
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "VelocityRender");
        }
        String view = mv.view();
        Template template = null;
        if (this.providerOfDebug != null) {
            try {
                template = this.providerOfDebug.getTemplate(view, Solon.encoding());
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.provider.getTemplate(view, Solon.encoding());
        }
        VelocityContext vc = new VelocityContext(mv.model());
        this.sharedVariables.forEach((k, v) -> vc.put(k, v));
        PrintWriter writer = new PrintWriter((OutputStream)outputStream.get());
        template.merge((org.apache.velocity.context.Context)vc, (Writer)writer);
        writer.flush();
    }
}

