/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;
import org.noear.solon.view.freemarker.XPluginImp;

public class FreemarkerRender
implements XRender {
    private static FreemarkerRender _global;
    Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
    private String _baseUri = "/WEB-INF/view/";

    public static FreemarkerRender global() {
        if (_global == null) {
            _global = new FreemarkerRender();
        }
        return _global;
    }

    public FreemarkerRender() {
        String baseUri = XApp.global().prop().get("slon.mvc.view.prefix");
        if (!XUtil.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (XApp.cfg().argx().getInt("debug") == 0) {
            this.forRelease();
        } else {
            this.forDebug();
        }
        this.cfg.setNumberFormat("#");
        this.cfg.setDefaultEncoding("utf-8");
        XApp.global().onSharedAdd((k, v) -> this.setSharedVariable((String)k, v));
    }

    private void forDebug() {
        String dirroot = XUtil.getResource((String)"/").toString().replace("target/classes/", "");
        String dir_str = dirroot + "src/main/resources" + this._baseUri;
        File dir = new File(URI.create(dir_str));
        if (!dir.exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir.exists()) {
                this.cfg.setDirectoryForTemplateLoading(dir);
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void forRelease() {
        try {
            this.cfg.setClassForTemplateLoading(this.getClass(), this._baseUri);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.cfg.setCacheStorage((CacheStorage)new MruCacheStorage(0, Integer.MAX_VALUE));
    }

    public void setSharedVariable(String name, Object value) {
        try {
            this.cfg.setSharedVariable(name, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void render(Object obj, XContext ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx);
        } else {
            ctx.output(obj.toString());
        }
    }

    public void render_mav(ModelAndView mv, XContext ctx) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.view", "FreemarkerRender");
        }
        PrintWriter writer = new PrintWriter(ctx.outputStream());
        Template template = this.cfg.getTemplate(mv.view(), "utf-8");
        template.process((Object)mv.model(), (Writer)writer);
    }
}

