/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.beetl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.core.tag.Tag;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.beetl.XPluginImp;

public class BeetlRender
implements Render {
    private static BeetlRender _global;
    Configuration cfg = null;
    GroupTemplate provider = null;
    GroupTemplate provider_debug = null;
    private String _baseUri = "/WEB-INF/view/";
    private ClassLoader classLoader;

    public static BeetlRender global() {
        if (_global == null) {
            _global = new BeetlRender();
        }
        return _global;
    }

    public BeetlRender() {
        this((ClassLoader)JarClassLoader.global());
    }

    public BeetlRender(ClassLoader classLoader) {
        this.classLoader = classLoader;
        try {
            this.cfg = Configuration.defaultConfiguration();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String baseUri = Solon.cfg().get("slon.mvc.view.prefix");
        if (!Utils.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        this.forDebug();
        this.forRelease();
        Solon.app().shared().forEach((k, v) -> this.putVariable((String)k, v));
        Solon.app().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (this.provider_debug != null) {
            return;
        }
        URL rooturi = Utils.getResource((String)"/");
        if (rooturi == null) {
            return;
        }
        String rootdir = rooturi.toString().replace("target/classes/", "");
        File dir = null;
        if (rootdir.startsWith("file:") && !(dir = new File(URI.create(dir_str = rootdir + "src/main/resources" + this._baseUri))).exists()) {
            dir_str = rootdir + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                FileResourceLoader loader = new FileResourceLoader(dir.getAbsolutePath(), Solon.encoding());
                this.provider_debug = new GroupTemplate((ResourceLoader)loader, this.cfg);
                EventBus.push((Object)this.provider_debug);
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        try {
            ClasspathResourceLoader loader = new ClasspathResourceLoader(this.classLoader, this._baseUri);
            this.provider = new GroupTemplate((ResourceLoader)loader, this.cfg);
            EventBus.push((Object)this.provider);
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void putDirective(String name, Class<? extends Tag> clz) {
        try {
            this.provider.registerTag(name, clz);
            if (this.provider_debug != null) {
                this.provider_debug.registerTag(name, clz);
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void putVariable(String name, Object value) {
        try {
            this.provider.getSharedVars().put(name, value);
            if (this.provider_debug != null) {
                this.provider_debug.getSharedVars().put(name, value);
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    private void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("Solon-View", "BeetlRender");
        }
        Template template = null;
        if (this.provider_debug != null && this.provider_debug.hasTemplate((Object)mv.view())) {
            template = this.provider_debug.getTemplate((Object)mv.view());
        }
        if (template == null) {
            template = this.provider.getTemplate((Object)mv.view());
        }
        template.binding(mv.model());
        template.renderTo((OutputStream)outputStream.get());
    }
}

