/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Email;

public class EmailValidator
implements Validator<Email> {
    private static final Map<String, Pattern> cached = new ConcurrentHashMap<String, Pattern>();
    public static final EmailValidator instance = new EmailValidator();

    public EmailValidator() {
        cached.putIfAbsent("", Pattern.compile("^[a-z]([a-z0-9]*[-_]?[a-z0-9]+)*@([a-z0-9]*[-_]?[a-z0-9]+)+[\\.][a-z]{2,3}([\\.][a-z]{2})?$"));
    }

    @Override
    public String message(Email anno) {
        return anno.message();
    }

    @Override
    public Result validateOfEntity(Class<?> clz, Email anno, String name, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof String)) {
            return Result.failure((String)(clz.getSimpleName() + "." + name));
        }
        String val = (String)val0;
        if (!this.verify(anno, val)) {
            return Result.failure((String)(clz.getSimpleName() + "." + name));
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Email anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!this.verify(anno, val)) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }

    private boolean verify(Email anno, String val) {
        if (Utils.isEmpty((String)val)) {
            return true;
        }
        Pattern pt = cached.get(anno.value());
        if (pt == null) {
            if (!anno.value().contains("@")) {
                throw new IllegalArgumentException("@Email value must have an @ sign");
            }
            pt = Pattern.compile(anno.value());
            cached.putIfAbsent(anno.value(), pt);
        }
        return pt.matcher(val).find();
    }
}

