/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation;

import org.noear.solon.core.Aop;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.ext.DataThrowable;
import org.noear.solon.validation.BeanValidator;
import org.noear.solon.validation.ValidatorManager;
import org.noear.solon.validation.annotation.Validated;

public class BeanValidateInterceptor
implements Interceptor {
    private BeanValidator validator;

    public BeanValidateInterceptor() {
        Aop.getAsyn(BeanValidator.class, bw -> {
            this.validator = (BeanValidator)bw.get();
        });
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        if (this.validator != null) {
            int len = inv.args().length;
            for (int i = 0; i < len; ++i) {
                Result r1;
                ParamWrap pw = inv.method().getParamWraps()[i];
                Validated v1 = pw.getParameter().getAnnotation(Validated.class);
                if (v1 == null || (r1 = this.validator.validate(inv.args()[i], v1.value())).getCode() != Result.FAILURE_CODE) continue;
                if (ValidatorManager.failureDo(Context.current(), v1, r1, r1.getDescription())) {
                    throw new DataThrowable();
                }
                throw new IllegalArgumentException(r1.getDescription());
            }
        }
        return inv.invoke();
    }
}

