/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.serialization.SerializationConfig;

public class StringSerializerRender
implements Render {
    private boolean typed;
    private Serializer<String> serializer;

    public StringSerializerRender(boolean typed, Serializer<String> serializer) {
        this.typed = typed;
        this.serializer = serializer;
    }

    public boolean isTyped() {
        return this.typed;
    }

    public Serializer<String> getSerializer() {
        return this.serializer;
    }

    public String getName() {
        return this.getClass().getSimpleName() + "#" + this.serializer.name();
    }

    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        return (String)this.serializer.serialize(data);
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (SerializationConfig.isOutputMeta()) {
            ctx.headerAdd("solon.serialization", this.getName());
        }
        String txt = null;
        if (this.typed) {
            txt = (String)this.serializer.serialize(obj);
        } else {
            if (obj == null) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
            txt = obj instanceof String ? (String)obj : (String)this.serializer.serialize(obj);
        }
        ctx.attrSet("output", (Object)txt);
        this.output(ctx, obj, txt);
    }

    protected void output(Context ctx, Object obj, String txt) {
        if (obj instanceof String && !ctx.accept().contains("/json")) {
            ctx.output(txt);
        } else {
            ctx.outputAsJson(txt);
        }
    }
}

